/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection;

import com.enjin.minecraft_commons.spigot.reflection.resolver.FieldResolver;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class Minecraft {
    static final Pattern NUMERIC_VERSION_PATTERN = Pattern.compile("v([0-9])_([0-9]*)_R([0-9])");
    public static final Version VERSION = Version.getVersion();

    public static String getVersion() {
        return VERSION.name() + ".";
    }

    public static enum Version {
        UNKNOWN(-1){

            @Override
            public boolean matchesPackageName(String packageName) {
                return false;
            }
        }
        ,
        v1_7_R1(10701),
        v1_7_R2(10702),
        v1_7_R3(10703),
        v1_7_R4(10704),
        v1_8_R1(10801),
        v1_8_R2(10802),
        v1_8_R3(10803),
        v1_8_R4(10804),
        v1_9_R1(10901),
        v1_9_R2(10902),
        v1_10_R1(11001),
        v1_11_R1(11101),
        v1_12_R1(11201),
        v1_13_R1(11301),
        v1_13_R2(11302);

        private int version;

        private Version(int version) {
            this.version = version;
        }

        public int version() {
            return this.version;
        }

        public boolean olderThan(Version version) {
            return this.version() < version.version();
        }

        public boolean newerThan(Version version) {
            return this.version() > version.version();
        }

        public boolean sameAs(Version version) {
            return this.version() == version.version();
        }

        public boolean sameOrOlderThan(Version version) {
            return this.sameAs(version) || this.olderThan(version);
        }

        public boolean sameOrNewerThan(Version version) {
            return this.sameAs(version) || this.newerThan(version);
        }

        public boolean inRange(Version oldVersion, Version newVersion) {
            return !(!this.sameAs(oldVersion) && !this.newerThan(oldVersion) || !this.sameAs(newVersion) && !this.olderThan(newVersion));
        }

        public boolean matchesPackageName(String packageName) {
            return packageName.toLowerCase().contains(this.name().toLowerCase());
        }

        public static Version getVersion() {
            String name = Bukkit.getServer().getClass().getPackage().getName();
            String versionPackage = name.substring(name.lastIndexOf(46) + 1) + ".";
            for (Version version : Version.values()) {
                if (!version.matchesPackageName(versionPackage)) continue;
                return version;
            }
            Matcher matcher = NUMERIC_VERSION_PATTERN.matcher(versionPackage);
            while (matcher.find()) {
                if (matcher.groupCount() < 3) continue;
                String majorString = matcher.group(1);
                String minorString = matcher.group(2);
                String patchString = matcher.group(2);
                if (minorString.length() == 1) {
                    minorString = "0" + minorString;
                }
                if (patchString.length() == 1) {
                    patchString = "0" + patchString;
                }
                String numVersionString = majorString + minorString + patchString;
                int numVersion = Integer.parseInt(numVersionString);
                String pack = versionPackage.substring(0, versionPackage.length() - 1);
                try {
                    Field valuesField = new FieldResolver(Version.class).resolve("$VALUES");
                    Version[] oldValues = (Version[])valuesField.get(null);
                    valuesField.set(null, oldValues);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.name() + " (" + this.version() + ")";
        }
    }
}

