/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.annotation;

import com.enjin.minecraft_commons.spigot.reflection.Minecraft;
import com.enjin.minecraft_commons.spigot.reflection.annotation.ClassDefinition;
import com.enjin.minecraft_commons.spigot.reflection.annotation.FieldDefinition;
import com.enjin.minecraft_commons.spigot.reflection.annotation.MethodDefinition;
import com.enjin.minecraft_commons.spigot.reflection.resolver.ClassResolver;
import com.enjin.minecraft_commons.spigot.reflection.resolver.FieldResolver;
import com.enjin.minecraft_commons.spigot.reflection.resolver.MethodResolver;
import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.ClassWrapper;
import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.FieldWrapper;
import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.MethodWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectionAnnotations {
    public static final ReflectionAnnotations INSTANCE = new ReflectionAnnotations();
    static final Pattern classRefPattern = Pattern.compile("@Class\\((.*)\\)");

    private ReflectionAnnotations() {
    }

    public void load(Object toLoad) {
        if (toLoad == null) {
            throw new IllegalArgumentException("toLoad cannot be null");
        }
        ClassResolver classResolver = new ClassResolver();
        for (Field field : toLoad.getClass().getDeclaredFields()) {
            String[] names;
            List<String> nameList;
            ClassDefinition classAnnotation = field.getAnnotation(ClassDefinition.class);
            FieldDefinition fieldAnnotation = field.getAnnotation(FieldDefinition.class);
            MethodDefinition methodAnnotation = field.getAnnotation(MethodDefinition.class);
            if (classAnnotation == null && fieldAnnotation == null && methodAnnotation == null) continue;
            field.setAccessible(true);
            if (classAnnotation != null) {
                nameList = this.parseAnnotationVersions(ClassDefinition.class, classAnnotation);
                if (nameList.isEmpty()) {
                    throw new IllegalArgumentException("@ClassDefinition names cannot be empty");
                }
                names = nameList.toArray(new String[0]);
                for (int i = 0; i < names.length; ++i) {
                    names[i] = names[i].replace("{nms}", "net.minecraft.server." + Minecraft.VERSION.name()).replace("{obc}", "org.bukkit.craftbukkit." + Minecraft.VERSION.name());
                }
                try {
                    if (ClassWrapper.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, classResolver.resolveWrapper(names));
                        continue;
                    }
                    if (Class.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, classResolver.resolve(names));
                        continue;
                    }
                    this.throwInvalidFieldType(field, toLoad, "Class or ClassWrapper");
                    return;
                }
                catch (ReflectiveOperationException e) {
                    if (classAnnotation.ignoreExceptions()) continue;
                    this.throwReflectionException("@ClassDefinition", field, toLoad, e);
                    return;
                }
            }
            if (fieldAnnotation != null) {
                nameList = this.parseAnnotationVersions(FieldDefinition.class, fieldAnnotation);
                if (nameList.isEmpty()) {
                    throw new IllegalArgumentException("@FieldDefenition names cannot be empty");
                }
                names = nameList.toArray(new String[0]);
                try {
                    FieldResolver fieldResolver = new FieldResolver(this.parseClass(FieldDefinition.class, fieldAnnotation, toLoad));
                    if (FieldWrapper.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, fieldResolver.resolveWrapper(names));
                        continue;
                    }
                    if (Field.class.isAssignableFrom(field.getType())) {
                        field.set(toLoad, fieldResolver.resolve(names));
                        continue;
                    }
                    this.throwInvalidFieldType(field, toLoad, "Field or FieldWrapper");
                }
                catch (ReflectiveOperationException e) {
                    if (fieldAnnotation.ignoreExceptions()) continue;
                    this.throwReflectionException("@FieldDefinition", field, toLoad, e);
                }
                continue;
            }
            if (methodAnnotation == null) continue;
            nameList = this.parseAnnotationVersions(MethodDefinition.class, methodAnnotation);
            if (nameList.isEmpty()) {
                throw new IllegalArgumentException("@MethodDefenition names cannot be empty");
            }
            names = nameList.toArray(new String[0]);
            boolean isSignature = names[0].contains(" ");
            for (String name : names) {
                if (name.contains(" ") == isSignature) continue;
                throw new IllegalArgumentException("Inconsistent method names: Cannot have mixed signatures/names");
            }
            try {
                MethodResolver methodResolver = new MethodResolver(this.parseClass(MethodDefinition.class, methodAnnotation, toLoad));
                if (MethodWrapper.class.isAssignableFrom(field.getType())) {
                    if (isSignature) {
                        field.set(toLoad, methodResolver.resolveSignatureWrapper(names));
                        continue;
                    }
                    field.set(toLoad, methodResolver.resolveWrapper(names));
                    continue;
                }
                if (Method.class.isAssignableFrom(field.getType())) {
                    if (isSignature) {
                        field.set(toLoad, methodResolver.resolveSignature(names));
                        continue;
                    }
                    field.set(toLoad, methodResolver.resolve(names));
                    continue;
                }
                this.throwInvalidFieldType(field, toLoad, "Method or MethodWrapper");
            }
            catch (ReflectiveOperationException e) {
                if (fieldAnnotation.ignoreExceptions()) continue;
                this.throwReflectionException("@FieldDefinition", field, toLoad, e);
            }
        }
    }

    <A extends Annotation> List<String> parseAnnotationVersions(Class<A> clazz, A annotation) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String[] names = (String[])clazz.getMethod("value", new Class[0]).invoke(annotation, new Object[0]);
            Minecraft.Version[] versions = (Minecraft.Version[])clazz.getMethod("versions", new Class[0]).invoke(annotation, new Object[0]);
            if (versions.length == 0) {
                for (String name : names) {
                    list.add(name);
                }
            } else {
                if (versions.length > names.length) {
                    throw new RuntimeException(String.format("versions array cannot have more elements than the names (%s)", clazz));
                }
                for (int i = 0; i < versions.length; ++i) {
                    if (Minecraft.VERSION == versions[i]) {
                        list.add(names[i]);
                        continue;
                    }
                    if (names[i].startsWith(">") && Minecraft.VERSION.newerThan(versions[i])) {
                        list.add(names[i].substring(1));
                        continue;
                    }
                    if (!names[i].startsWith("<") || !Minecraft.VERSION.olderThan(versions[i])) continue;
                    list.add(names[i].substring(1));
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    <A extends Annotation> String parseClass(Class<A> clazz, A annotation, Object toLoad) {
        try {
            String className = (String)clazz.getMethod("className", new Class[0]).invoke(annotation, new Object[0]);
            Matcher matcher = classRefPattern.matcher(className);
            while (matcher.find()) {
                if (matcher.groupCount() != 1) continue;
                String fieldName = matcher.group(1);
                Field field = toLoad.getClass().getField(fieldName);
                if (ClassWrapper.class.isAssignableFrom(field.getType())) {
                    return ((ClassWrapper)field.get(toLoad)).getName();
                }
                if (!Class.class.isAssignableFrom(field.getType())) continue;
                return ((Class)field.get(toLoad)).getName();
            }
            return className;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    void throwInvalidFieldType(Field field, Object toLoad, String expected) {
        throw new IllegalArgumentException(String.format("Field %s in %s is not of type %s, it's %s", field.getName(), toLoad.getClass(), expected, field.getType()));
    }

    void throwReflectionException(String annotation, Field field, Object toLoad, ReflectiveOperationException exception) {
        throw new RuntimeException(String.format("Failed to set %s field %s in %s", annotation, field.getName(), toLoad.getClass()), exception);
    }
}

