/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.resolver;

import com.enjin.minecraft_commons.spigot.reflection.resolver.MemberResolver;
import com.enjin.minecraft_commons.spigot.reflection.resolver.ResolverQuery;
import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.ConstructorWrapper;
import com.enjin.minecraft_commons.spigot.reflection.util.AccessUtil;
import java.lang.reflect.Constructor;

public class ConstructorResolver
extends MemberResolver<Constructor> {
    public ConstructorResolver(Class<?> clazz) {
        super(clazz);
    }

    public ConstructorResolver(String className) throws ClassNotFoundException {
        super(className);
    }

    @Override
    public Constructor resolveIndex(int index) throws IndexOutOfBoundsException, ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredConstructors()[index]);
    }

    @Override
    public Constructor resolveIndexSilent(int index) {
        try {
            return this.resolveIndex(index);
        }
        catch (IndexOutOfBoundsException | ReflectiveOperationException exception) {
            return null;
        }
    }

    @Override
    public ConstructorWrapper resolveIndexWrapper(int index) {
        return new ConstructorWrapper(this.resolveIndexSilent(index));
    }

    public ConstructorWrapper resolveWrapper(Class<?>[] ... types) {
        return new ConstructorWrapper(this.resolveSilent(types));
    }

    public Constructor resolveSilent(Class<?>[] ... types) {
        try {
            return this.resolve(types);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Constructor resolve(Class<?>[] ... types) throws NoSuchMethodException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (Class<?>[] type : types) {
            builder.with(type);
        }
        try {
            return (Constructor)super.resolve(builder.build());
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchMethodException)e;
        }
    }

    @Override
    protected Constructor resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredConstructor(query.getTypes()));
    }

    public Constructor resolveFirstConstructor() throws ReflectiveOperationException {
        int n = 0;
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        int n2 = constructorArray.length;
        if (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            return AccessUtil.setAccessible(constructor);
        }
        return null;
    }

    public Constructor resolveFirstConstructorSilent() {
        try {
            return this.resolveFirstConstructor();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Constructor resolveLastConstructor() throws ReflectiveOperationException {
        Constructor<?> result = null;
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<?> constructor;
            result = constructor = constructorArray[i];
        }
        if (result != null) {
            return AccessUtil.setAccessible(result);
        }
        return null;
    }

    public Constructor resolveLastConstructorSilent() {
        try {
            return this.resolveLastConstructor();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected ReflectiveOperationException notFoundException(String joinedNames) {
        return new NoSuchMethodException(String.format("Could not resolve constructor for %s in class %s", joinedNames, this.clazz));
    }
}

