/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.resolver;

import com.enjin.minecraft_commons.spigot.reflection.resolver.MemberResolver;
import com.enjin.minecraft_commons.spigot.reflection.resolver.ResolverQuery;
import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.MethodWrapper;
import com.enjin.minecraft_commons.spigot.reflection.util.AccessUtil;
import java.lang.reflect.Method;
import java.util.Objects;

public class MethodResolver
extends MemberResolver<Method> {
    public MethodResolver(Class<?> clazz) {
        super(clazz);
    }

    public MethodResolver(String className) throws ClassNotFoundException {
        super(className);
    }

    public Method resolveSignature(String ... signatures) throws ReflectiveOperationException {
        for (Method method : this.clazz.getDeclaredMethods()) {
            String methodSignature = MethodWrapper.getMethodSignature(method);
            for (String signature : signatures) {
                if (!signature.equals(methodSignature)) continue;
                return AccessUtil.setAccessible(method);
            }
        }
        return null;
    }

    public Method resolveSignatureSilent(String ... signatures) {
        try {
            return this.resolveSignature(signatures);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return null;
        }
    }

    public MethodWrapper resolveSignatureWrapper(String ... signatures) {
        return new MethodWrapper(this.resolveSignatureSilent(signatures));
    }

    @Override
    public Method resolveIndex(int index) throws IndexOutOfBoundsException, ReflectiveOperationException {
        return AccessUtil.setAccessible(this.clazz.getDeclaredMethods()[index]);
    }

    @Override
    public Method resolveIndexSilent(int index) {
        try {
            return this.resolveIndex(index);
        }
        catch (IndexOutOfBoundsException | ReflectiveOperationException exception) {
            return null;
        }
    }

    @Override
    public MethodWrapper resolveIndexWrapper(int index) {
        return new MethodWrapper(this.resolveIndexSilent(index));
    }

    public MethodWrapper resolveWrapper(String ... names) {
        return new MethodWrapper(this.resolveSilent(names));
    }

    public MethodWrapper resolveWrapper(ResolverQuery ... queries) {
        return new MethodWrapper(this.resolveSilent(queries));
    }

    public Method resolveSilent(String ... names) {
        try {
            return this.resolve(names);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Method resolveSilent(ResolverQuery ... queries) {
        return (Method)super.resolveSilent(queries);
    }

    public Method resolve(String ... names) throws NoSuchMethodException {
        ResolverQuery.Builder builder = ResolverQuery.builder();
        for (String name : names) {
            builder.with(name);
        }
        return this.resolve(builder.build());
    }

    @Override
    public Method resolve(ResolverQuery ... queries) throws NoSuchMethodException {
        try {
            return (Method)super.resolve(queries);
        }
        catch (ReflectiveOperationException e) {
            throw (NoSuchMethodException)e;
        }
    }

    @Override
    protected Method resolveObject(ResolverQuery query) throws ReflectiveOperationException {
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.getName().equals(query.getName()) || query.getTypes().length != 0 && !MethodResolver.classArraysEqual(query.getTypes(), method.getParameterTypes())) continue;
            return AccessUtil.setAccessible(method);
        }
        throw new NoSuchMethodException();
    }

    @Override
    protected NoSuchMethodException notFoundException(String joinedNames) {
        return new NoSuchMethodException(String.format("Could not resolve method for %s in class %s", joinedNames, this.clazz));
    }

    static boolean classArraysEqual(Class<?>[] array1, Class<?>[] array2) {
        boolean equal = true;
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Objects.equals(array1[i], array2[i])) continue;
            equal = false;
            break;
        }
        return equal;
    }
}

