/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.resolver;

import com.enjin.minecraft_commons.spigot.reflection.resolver.ResolverQuery;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ResolverAbstract<T> {
    private final Map<ResolverQuery, T> resolvedObjects = new ConcurrentHashMap<ResolverQuery, T>();

    protected T resolveSilent(ResolverQuery ... queries) {
        try {
            return this.resolve(queries);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected T resolve(ResolverQuery ... queries) throws ReflectiveOperationException {
        if (queries == null || queries.length <= 0) {
            throw new IllegalArgumentException("queries must not be null or empty");
        }
        for (ResolverQuery query : queries) {
            if (this.resolvedObjects.containsKey(query)) {
                return this.resolvedObjects.get(query);
            }
            try {
                T resolved = this.resolveObject(query);
                this.resolvedObjects.put(query, resolved);
                return resolved;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        throw this.notFoundException(Arrays.asList(queries).toString());
    }

    protected abstract T resolveObject(ResolverQuery var1) throws ReflectiveOperationException;

    protected ReflectiveOperationException notFoundException(String joinedNames) {
        return new ClassNotFoundException(String.format("Objects could not be resolved: %s", joinedNames));
    }
}

