/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResolverQuery {
    private String name;
    private Class<?>[] types;

    public ResolverQuery(String name, Class<?> ... types) {
        this.name = name;
        this.types = types;
    }

    public ResolverQuery(String name) {
        this.name = name;
        this.types = new Class[0];
    }

    public ResolverQuery(Class<?> ... types) {
        this.types = types;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolverQuery that = (ResolverQuery)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return Arrays.equals(this.types, that.types);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    public String toString() {
        return "ResolverQuery{name='" + this.name + '\'' + ", types=" + Arrays.toString(this.types) + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ResolverQuery> queryList = new ArrayList<ResolverQuery>();

        private Builder() {
        }

        public Builder with(String name, Class<?>[] types) {
            this.queryList.add(new ResolverQuery(name, types));
            return this;
        }

        public Builder with(String name) {
            this.queryList.add(new ResolverQuery(name));
            return this;
        }

        public Builder with(Class<?>[] types) {
            this.queryList.add(new ResolverQuery(types));
            return this;
        }

        public ResolverQuery[] build() {
            return this.queryList.toArray(new ResolverQuery[0]);
        }
    }
}

