/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper;

import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.WrapperAbstract;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class ConstructorWrapper<R>
extends WrapperAbstract {
    private final Constructor<R> constructor;

    public ConstructorWrapper(Constructor<R> constructor) {
        this.constructor = constructor;
    }

    @Override
    public boolean exists() {
        return this.constructor != null;
    }

    public R newInstance(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public R newInstanceSilent(Object args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class<?>[] getParameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public Constructor<R> getConstructor() {
        return this.constructor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConstructorWrapper that = (ConstructorWrapper)object;
        return Objects.equals(this.constructor, that.constructor);
    }

    public int hashCode() {
        return Objects.hash(this.constructor);
    }
}

