/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper;

import com.enjin.minecraft_commons.spigot.reflection.resolver.wrapper.WrapperAbstract;
import java.lang.reflect.Field;
import java.util.Objects;

public class FieldWrapper<R>
extends WrapperAbstract {
    private final Field field;

    public FieldWrapper(Field field) {
        this.field = field;
    }

    @Override
    public boolean exists() {
        return this.field != null;
    }

    public String getName() {
        return this.field.getName();
    }

    public R get(Object object) {
        try {
            return (R)this.field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public R getSilent(Object object) {
        try {
            return (R)this.field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void set(Object object, R value) {
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSilent(Object object, R value) {
        try {
            this.field.set(object, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Field getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldWrapper that = (FieldWrapper)o;
        return Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field);
    }
}

