/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.ui;

import com.enjin.minecraft_commons.spigot.ui.ClickHandler;
import com.enjin.minecraft_commons.spigot.ui.Container;
import com.enjin.minecraft_commons.spigot.ui.Dimension;
import com.enjin.minecraft_commons.spigot.ui.Position;
import com.enjin.minecraft_commons.spigot.ui.SlotUpdateHandler;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public interface Component {
    public Dimension getDimension();

    public Container getParent();

    public void setParent(Container var1);

    public void draw(Player var1);

    default public void setItem(Player target, Position position, ItemStack stack) {
        Preconditions.checkArgument((position.getX() >= 0 && position.getX() < this.getDimension().getWidth() ? 1 : 0) != 0, (Object)"X has to be [0 - width)");
        Preconditions.checkArgument((position.getY() >= 0 && position.getY() < this.getDimension().getHeight() ? 1 : 0) != 0, (Object)"Y has to be [0 - height)");
        this.getParent().setItem(target, this, position, stack);
    }

    default public void onOpen(Player player) {
    }

    default public void onClose(Player player) {
    }

    default public void onClick(Player player, ClickType clickType, Position position) {
    }

    default public void onPlace(Player player, ItemStack current, ItemStack cursor, Position position) {
    }

    default public void onDrag(Player player, ItemStack current, ItemStack cursor, Position position) {
    }

    default public void onPickup(Player player, ItemStack current, ItemStack cursor, Position position) {
    }

    public boolean isAllowPlace();

    public boolean isAllowDrag();

    public boolean isAllowPickup();

    public void setAllowPlace(boolean var1);

    public void setAllowDrag(boolean var1);

    public void setAllowPickup(boolean var1);

    public Optional<SlotUpdateHandler> getSlotUpdateHandler();

    public Optional<ClickHandler> getClickHandler();

    public int size();
}

