/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.ui;

import com.enjin.minecraft_commons.spigot.ui.AbstractMenu;
import com.enjin.minecraft_commons.spigot.ui.Component;
import com.enjin.minecraft_commons.spigot.ui.Dimension;
import com.enjin.minecraft_commons.spigot.ui.Position;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Menu
extends AbstractMenu
implements Listener {
    private static final InventoryAction[] placeActions = new InventoryAction[]{InventoryAction.PLACE_ONE, InventoryAction.PLACE_SOME, InventoryAction.PLACE_ALL};
    private static final InventoryAction[] pickupActions = new InventoryAction[]{InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_ALL};

    public Menu(String name, Dimension dimension) {
        super(name, dimension);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Menu.getHolder());
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!this.isNameSwitch() && this.hasOpen(player)) {
            this.getComponents().keySet().forEach(component -> {
                try {
                    component.onClose(player);
                }
                catch (Throwable t) {
                    Menu.getHolder().getLogger().log(Level.WARNING, "An exception was caught while handling a component.", t);
                }
            });
            this.removePlayer(player);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.hasOpen(player)) {
            InventoryView snapshot = event.getView();
            ItemStack cursor = event.getCursor();
            HashMap<Integer, ItemStack> rollback = new HashMap<Integer, ItemStack>();
            for (Map.Entry entry : event.getNewItems().entrySet()) {
                int slot = (Integer)entry.getKey();
                if (slot >= this.getSize()) continue;
                Optional<Component> optional = this.getComponent(slot);
                ItemStack item = (ItemStack)entry.getValue();
                if (!optional.isPresent() || optional.isPresent() && !optional.get().isAllowDrag()) {
                    int diff;
                    ItemStack old = snapshot.getItem(slot);
                    int n = diff = old == null ? item.getAmount() : item.getAmount() - old.getAmount();
                    if (cursor == null) {
                        cursor = item.clone();
                        cursor.setAmount(diff);
                    } else {
                        cursor.setAmount(cursor.getAmount() + diff);
                    }
                    rollback.put(slot, old);
                    continue;
                }
                Component component = optional.get();
                Position inventoryPosition = Position.toPosition(this, slot);
                Position componentPosition = this.getComponents().get(component);
                Position normalizedPosition = Position.normalize(inventoryPosition, componentPosition);
                component.setItem(player, normalizedPosition, item);
                component.getSlotUpdateHandler().ifPresent(handler -> handler.handle(player, slot, snapshot.getItem(slot), item));
            }
            if (!rollback.isEmpty()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Menu.getHolder(), () -> {
                    rollback.forEach((slot, item) -> player.getOpenInventory().setItem(slot.intValue(), item));
                    player.updateInventory();
                }, 1L);
            }
            event.setCursor(cursor);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.hasOpen(player)) {
            int slot = event.getSlot();
            if (slot >= this.getSize()) {
                return;
            }
            Inventory inventory = event.getClickedInventory();
            if (inventory == player.getInventory()) {
                if (!this.isPlayerInventoryInteractionsAllowed()) {
                    event.setResult(Event.Result.DENY);
                } else {
                    this.validatePlayerInventoryAction(event);
                }
            } else {
                event.setResult(Event.Result.DENY);
                if (event.getClickedInventory() != event.getInventory()) {
                    return;
                }
                Optional<Component> optionalComponent = this.getComponent(slot);
                if (optionalComponent.isPresent()) {
                    Component component = optionalComponent.get();
                    if (component.isAllowPlace() && Stream.of(placeActions).anyMatch(a -> a.equals((Object)event.getAction()))) {
                        event.setResult(Event.Result.DEFAULT);
                        this.handlePlace(player, slot, event.getCurrentItem(), event.getCursor(), component);
                        ItemStack existing = event.getCurrentItem();
                        ItemStack placed = event.getCursor();
                        if (existing != null && placed != null) {
                            placed = placed.clone();
                            placed.setAmount(placed.getAmount() + existing.getAmount());
                        }
                        ItemStack newItem = placed;
                        component.getSlotUpdateHandler().ifPresent(handler -> handler.handle(player, slot, existing, newItem));
                    } else if (component.isAllowPickup() && Stream.of(pickupActions).anyMatch(a -> a.equals((Object)event.getAction()))) {
                        event.setResult(Event.Result.DEFAULT);
                        this.handlePickup(player, slot, event.getCurrentItem(), event.getCursor(), component);
                        component.getSlotUpdateHandler().ifPresent(handler -> handler.handle(player, slot, event.getCurrentItem(), event.getCursor()));
                    } else {
                        this.handleClick(player, event.getClick(), slot, component);
                    }
                }
            }
        }
    }

    private void handlePickup(Player player, int slot, ItemStack current, ItemStack cursor, Component component) {
        Position pos = this.getComponents().get(component);
        Position slotPos = Position.toPosition(this, slot);
        Position offsetPos = Position.of(slotPos.getX() - pos.getX(), slotPos.getY() - pos.getY());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Menu.getHolder(), () -> component.onPickup(player, current, cursor, offsetPos));
    }

    private void handlePlace(Player player, int slot, ItemStack current, ItemStack cursor, Component component) {
        Position pos = this.getComponents().get(component);
        Position slotPos = Position.toPosition(this, slot);
        Position offsetPos = Position.of(slotPos.getX() - pos.getX(), slotPos.getY() - pos.getY());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Menu.getHolder(), () -> component.onPlace(player, current, cursor, offsetPos));
    }

    private void handleClick(Player player, ClickType type, int slot, Component component) {
        Position pos = this.getComponents().get(component);
        Position slotPos = Position.toPosition(this, slot);
        Position offsetPos = Position.of(slotPos.getX() - pos.getX(), slotPos.getY() - pos.getY());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Menu.getHolder(), () -> component.onClick(player, type, offsetPos));
    }

    private void validatePlayerInventoryAction(InventoryClickEvent event) {
        switch (event.getAction()) {
            case MOVE_TO_OTHER_INVENTORY: 
            case COLLECT_TO_CURSOR: {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

