/*
 * Decompiled with CFR 0.152.
 */
package com.enjin.minecraft_commons.spigot.ui.menu.component;

import com.enjin.minecraft_commons.spigot.ui.Dimension;
import com.enjin.minecraft_commons.spigot.ui.Position;
import com.enjin.minecraft_commons.spigot.ui.menu.component.MenuComponent;
import com.enjin.minecraft_commons.spigot.ui.menu.component.pagination.PagedComponent;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class SimpleMenuComponent
extends MenuComponent {
    private ItemStack[][] contents;

    public SimpleMenuComponent(Dimension dimension) {
        super(dimension);
        this.contents = new ItemStack[dimension.getHeight()][dimension.getWidth()];
    }

    public void setItem(Position position, ItemStack stack) {
        this.setItem(position.getX(), position.getY(), stack);
    }

    public void setItem(Position position, ItemStack stack, Consumer<Player> action) {
        this.setItem(position, stack);
        this.addAction(position, action, ClickType.LEFT, new ClickType[0]);
    }

    public void setItem(int x, int y, ItemStack stack) {
        this.contents[y][x] = stack;
    }

    public void removeItem(Position position) {
        this.removeItem(position.getX(), position.getY());
    }

    public void removeItem(int x, int y) {
        this.contents[y][x] = null;
    }

    public ItemStack getItem(Position position) {
        return this.getItem(position.getX(), position.getY());
    }

    public ItemStack getItem(int x, int y) {
        return this.contents[y][x];
    }

    public void setToggle(Position position, boolean onState, ItemStack on, ItemStack off, BiConsumer<Player, Boolean> toggle) {
        ToggleConsumer consumer = new ToggleConsumer(toggle, onState);
        this.addAction(position, player -> {
            consumer.accept((Player)player);
            this.setItem(position, consumer.getState() ? on : off);
            this.getParent().updateAll();
        }, ClickType.LEFT, new ClickType[0]);
        this.setItem(position, onState ? on : off);
    }

    public void setNextPage(Position position, PagedComponent component, BiFunction<Integer, Integer, ItemStack> pageStack, Function<Integer, ItemStack> last) {
        this.setItem(position, pageStack.apply(0, 0), (Player player) -> component.nextPage((Player)player));
        component.onPage((player, page) -> {
            if (page < component.getPageCount(player) - 1) {
                this.setItem(player, position, (ItemStack)pageStack.apply(component.getPageNumber(player) + 1, component.getPageCount(player)));
            } else {
                this.setItem(player, position, (ItemStack)last.apply(component.getPageCount(player)));
            }
            return true;
        });
    }

    public void setPreviousPage(Position position, PagedComponent component, BiFunction<Integer, Integer, ItemStack> pageStack, Function<Integer, ItemStack> first) {
        this.setItem(position, pageStack.apply(0, 0), (Player player) -> component.previousPage((Player)player));
        component.onPage((player, page) -> {
            if (0 < page) {
                this.setItem(player, position, (ItemStack)pageStack.apply(component.getPageNumber(player) + 1, component.getPageCount(player)));
            } else {
                this.setItem(player, position, (ItemStack)first.apply(component.getPageCount(player)));
            }
            return true;
        });
    }

    @Override
    public void draw(Player player) {
        IntStream.range(0, this.getDimension().getHeight()).forEach(y -> IntStream.range(0, this.getDimension().getWidth()).forEach(x -> {
            Position pos = Position.of(x, y);
            this.setItem(player, pos, this.contents[y][x]);
        }));
    }

    protected static class ToggleConsumer
    implements Consumer<Player> {
        private final BiConsumer<Player, Boolean> toggleAction;
        private boolean state;

        private ToggleConsumer() {
            throw new IllegalStateException();
        }

        ToggleConsumer(BiConsumer<Player, Boolean> toggleAction, boolean state) {
            this.toggleAction = toggleAction;
            this.state = state;
        }

        @Override
        public void accept(Player player) {
            this.state = !this.state;
            this.toggleAction.accept(player, this.state);
        }

        public boolean getState() {
            return this.state;
        }
    }
}

