/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.maven;

import com.enofex.naikan.maven.ProviderFactory;
import com.enofex.naikan.model.AbstractContainer;
import com.enofex.naikan.model.Bom;
import com.enofex.naikan.model.Contact;
import com.enofex.naikan.model.Contacts;
import com.enofex.naikan.model.Developer;
import com.enofex.naikan.model.Developers;
import com.enofex.naikan.model.Documentation;
import com.enofex.naikan.model.Documentations;
import com.enofex.naikan.model.Environment;
import com.enofex.naikan.model.Environments;
import com.enofex.naikan.model.Integration;
import com.enofex.naikan.model.Integrations;
import com.enofex.naikan.model.License;
import com.enofex.naikan.model.Licenses;
import com.enofex.naikan.model.Organization;
import com.enofex.naikan.model.Project;
import com.enofex.naikan.model.Roles;
import com.enofex.naikan.model.Tags;
import com.enofex.naikan.model.Team;
import com.enofex.naikan.model.Teams;
import com.enofex.naikan.model.Technologies;
import com.enofex.naikan.model.Technology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;

final class Merger {
    private Merger() {
    }

    static <T> T merge(MavenProject project, Bom existingBom, Class<T> clazz) {
        List<Object> objects = ProviderFactory.providers(clazz).stream().map(p -> p.provide(project, existingBom)).toList();
        if (objects.size() == 1) {
            return (T)objects.get(0);
        }
        if (objects.size() > 1) {
            Object object = objects.get(0);
            for (int i = 1; i < objects.size(); ++i) {
                object = Merger.merge(object, objects.get(i));
            }
            return (T)object;
        }
        return null;
    }

    private static <T> T merge(T o1, T o2) {
        if (o1 instanceof Project) {
            return (T)Merger.merge((Project)o1, (Project)o2);
        }
        if (o1 instanceof Organization) {
            return (T)Merger.merge((Organization)o1, (Organization)o2);
        }
        if (o1 instanceof Environments) {
            return (T)new Environments(Merger.merge((Environments)o1, (Environments)o2, Environment::name));
        }
        if (o1 instanceof Environment) {
            return (T)Merger.merge((Environment)o1, (Environment)o2);
        }
        if (o1 instanceof Teams) {
            return (T)new Teams(Merger.merge((Teams)o1, (Teams)o2, Team::name));
        }
        if (o1 instanceof Team) {
            return (T)Merger.merge((Team)o1, (Team)o2);
        }
        if (o1 instanceof Developers) {
            return (T)new Developers(Merger.merge((Developers)o1, (Developers)o2, Developer::name));
        }
        if (o1 instanceof Developer) {
            return (T)Merger.merge((Developer)o1, (Developer)o2);
        }
        if (o1 instanceof Contacts) {
            return (T)new Contacts(Merger.merge((Contacts)o1, (Contacts)o2, Contact::name));
        }
        if (o1 instanceof Contact) {
            return (T)Merger.merge((Contact)o1, (Contact)o2);
        }
        if (o1 instanceof Technologies) {
            return (T)new Technologies(Merger.merge((Technologies)o1, (Technologies)o2, Technology::name));
        }
        if (o1 instanceof Technology) {
            return (T)Merger.merge((Technology)o1, (Technology)o2);
        }
        if (o1 instanceof Licenses) {
            return (T)new Licenses(Merger.merge((Licenses)o1, (Licenses)o2, License::name));
        }
        if (o1 instanceof License) {
            return (T)Merger.merge((License)o1, (License)o2);
        }
        if (o1 instanceof Documentations) {
            return (T)new Documentations(Merger.merge((Documentations)o1, (Documentations)o2, Documentation::name));
        }
        if (o1 instanceof Documentation) {
            return (T)Merger.merge((Documentation)o1, (Documentation)o2);
        }
        if (o1 instanceof Integrations) {
            return (T)new Integrations(Merger.merge((Integrations)o1, (Integrations)o2, Integration::name));
        }
        if (o1 instanceof Integration) {
            return (T)Merger.merge((Integration)o1, (Integration)o2);
        }
        if (o1 instanceof Tags) {
            return (T)Merger.mergeTags((Tags)o1, (Tags)o2);
        }
        return o1;
    }

    private static <T> List<T> merge(AbstractContainer<T> o1, AbstractContainer<T> o2, Function<? super T, String> groupBy) {
        Map<String, List<T>> grouped = Stream.of(o1.all(), o2.all()).flatMap(Collection::stream).collect(Collectors.groupingBy(groupBy));
        ArrayList<T> objects = new ArrayList<T>();
        for (Map.Entry<String, List<T>> entry : grouped.entrySet()) {
            if (entry.getValue().size() == 1) {
                objects.add(entry.getValue().get(0));
                continue;
            }
            if (entry.getValue().size() <= 1) continue;
            T object = entry.getValue().get(0);
            for (int i = 1; i < entry.getValue().size(); ++i) {
                object = Merger.merge(object, entry.getValue().get(i));
            }
            objects.add(object);
        }
        return objects;
    }

    private static Project merge(Project p1, Project p2) {
        if (p1.name() == null || !p1.name().equals(p2.name())) {
            return p1;
        }
        return new Project(p1.name(), p2.inceptionYear() != null ? p2.inceptionYear() : p1.inceptionYear(), p2.url() != null ? p2.url() : p1.url(), p2.repository() != null ? p2.repository() : p1.repository(), p2.packaging() != null ? p2.packaging() : p1.packaging(), p2.groupId() != null ? p2.groupId() : p1.groupId(), p2.artifactId() != null ? p2.artifactId() : p1.artifactId(), p2.version() != null ? p2.version() : p1.version(), p2.description() != null ? p2.description() : p1.description(), p2.notes() != null ? p2.notes() : p1.notes());
    }

    private static Organization merge(Organization o1, Organization o2) {
        if (o1.name() == null || !o1.name().equals(o2.name())) {
            return o1;
        }
        return new Organization(o1.name(), o2.url() != null ? o2.url() : o1.url(), o2.department() != null ? o2.department() : o1.department(), o2.description() != null ? o2.description() : o1.description());
    }

    private static Environment merge(Environment e1, Environment e2) {
        if (e1.name() == null || !e1.name().equals(e2.name())) {
            return e1;
        }
        return new Environment(e1.name(), e2.location() != null ? e2.location() : e1.location(), e2.description() != null ? e2.description() : e1.description(), Merger.mergeTags(e1.tags(), e2.tags()));
    }

    private static Team merge(Team t1, Team t2) {
        if (t1.name() == null || !t1.name().equals(t2.name())) {
            return t1;
        }
        return new Team(t1.name(), t2.description() != null ? t2.description() : t1.description());
    }

    private static Developer merge(Developer d1, Developer d2) {
        if (d1.name() == null || !d1.name().equals(d2.name())) {
            return d1;
        }
        return new Developer(d2.name(), d2.username() != null ? d2.username() : d1.username(), d2.title() != null ? d2.title() : d1.title(), d2.department() != null ? d2.department() : d1.department(), d2.email() != null ? d2.email() : d1.email(), d2.phone() != null ? d2.phone() : d1.phone(), d2.organization() != null ? d2.organization() : d1.organization(), d2.organizationUrl() != null ? d2.organizationUrl() : d1.organizationUrl(), d2.timezone() != null ? d2.timezone() : d1.timezone(), d2.description() != null ? d2.description() : d1.description(), Merger.mergeRoles(d1.roles(), d2.roles()));
    }

    private static Contact merge(Contact c1, Contact c2) {
        if (c1.name() == null || !c1.name().equals(c2.name())) {
            return c1;
        }
        return new Contact(c1.name(), c2.title() != null ? c2.title() : c1.title(), c2.email() != null ? c2.email() : c1.email(), c2.phone() != null ? c2.phone() : c1.phone(), c2.description() != null ? c2.description() : c1.description(), Merger.mergeRoles(c1.roles(), c2.roles()));
    }

    private static Technology merge(Technology t1, Technology t2) {
        if (t1.name() == null || !t1.name().equals(t2.name())) {
            return t1;
        }
        return new Technology(t1.name(), t2.version() != null ? t2.version() : t1.version(), t2.description() != null ? t2.description() : t1.description(), Merger.mergeTags(t1.tags(), t2.tags()));
    }

    private static License merge(License l1, License l2) {
        if (l1.name() == null || !l1.name().equals(l2.name())) {
            return l1;
        }
        return new License(l1.name(), l2.url() != null ? l2.url() : l1.url(), l2.description() != null ? l2.description() : l1.description());
    }

    private static Documentation merge(Documentation d1, Documentation d2) {
        if (d1.name() == null || !d1.name().equals(d2.name())) {
            return d1;
        }
        return new Documentation(d1.name(), d2.location() != null ? d2.location() : d1.location(), d2.description() != null ? d2.description() : d1.description(), Merger.mergeTags(d1.tags(), d1.tags()));
    }

    private static Integration merge(Integration i1, Integration i2) {
        if (i1.name() == null || !i1.name().equals(i2.name())) {
            return i1;
        }
        return new Integration(i1.name(), i2.url() != null ? i2.url() : i1.url(), i2.description() != null ? i2.description() : i1.description(), Merger.mergeTags(i1.tags(), i2.tags()));
    }

    private static Tags mergeTags(Tags first, Tags second) {
        return new Tags(Stream.of(first != null ? first.all() : List.of(), second != null ? second.all() : List.of()).flatMap(Collection::stream).distinct().toList());
    }

    private static Roles mergeRoles(Roles first, Roles second) {
        return new Roles(Stream.of(first != null ? first.all() : List.of(), second != null ? second.all() : List.of()).flatMap(Collection::stream).distinct().toList());
    }
}

