/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.maven.provider.git;

import com.enofex.naikan.maven.provider.git.GitProvider;
import com.enofex.naikan.model.Bom;
import com.enofex.naikan.model.Branches;
import com.enofex.naikan.model.Commit;
import com.enofex.naikan.model.CommitAuthor;
import com.enofex.naikan.model.CommitChanges;
import com.enofex.naikan.model.CommitFilesChanges;
import com.enofex.naikan.model.CommitLinesChanges;
import com.enofex.naikan.model.Commits;
import com.enofex.naikan.model.RepositoryTag;
import com.enofex.naikan.model.RepositoryTags;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public final class RepositoryProvider
extends GitProvider<com.enofex.naikan.model.Repository> {
    @Override
    public com.enofex.naikan.model.Repository provide(MavenSession session, MavenProject project, Bom existingBom) {
        Repository repository = this.gitRepository(project.getBasedir());
        if (repository != null) {
            return new com.enofex.naikan.model.Repository(this.name(repository), this.url(repository), this.firstCommit(repository), this.totalCommits(repository), this.defaultBranch(repository), this.branches(repository), this.tags(repository), this.commits(repository));
        }
        return null;
    }

    private String name(Repository repository) {
        String url = this.url(repository);
        if (url != null) {
            String[] parts = url.split("/|:");
            String repositoryWithExtension = parts[parts.length - 1];
            int dotIndex = repositoryWithExtension.lastIndexOf(46);
            return dotIndex != -1 ? repositoryWithExtension.substring(0, dotIndex) : repositoryWithExtension;
        }
        return null;
    }

    private int totalCommits(Repository repository) {
        int n;
        Git git = new Git(repository);
        try {
            AtomicInteger count = new AtomicInteger();
            git.log().add((AnyObjectId)repository.resolve(repository.getFullBranch())).setRevFilter(RevFilter.NO_MERGES).call().forEach(revCommit -> count.getAndIncrement());
            n = count.get();
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                return 0;
            }
        }
        git.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Commit firstCommit(Repository repository) {
        try (RevWalk revWalk = new RevWalk(repository);){
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)repository.resolve("HEAD")));
            revWalk.sort(RevSort.COMMIT_TIME_DESC);
            revWalk.sort(RevSort.REVERSE);
            RevCommit commit = revWalk.next();
            if (commit == null) return null;
            Commit commit2 = this.commit(repository, commit);
            return commit2;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return null;
    }

    private String defaultBranch(Repository repository) {
        try {
            return repository.getBranch();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    private RepositoryTags tags(Repository repository) {
        RepositoryTags repositoryTags;
        Git git = new Git(repository);
        try {
            List tags = git.tagList().call();
            ArrayList<RepositoryTag> repositoryTags2 = new ArrayList<RepositoryTag>(tags.size());
            try (RevWalk revWalk = new RevWalk(repository);){
                for (Ref tag : tags) {
                    RevObject targetObject;
                    int timestamp = 0;
                    RevObject revObject = revWalk.parseAny((AnyObjectId)tag.getObjectId());
                    if (revObject instanceof RevCommit) {
                        timestamp = ((RevCommit)revObject).getCommitTime();
                    } else if (revObject instanceof RevTag && (targetObject = revWalk.parseAny((AnyObjectId)((RevTag)revObject).getObject())) instanceof RevCommit) {
                        timestamp = ((RevCommit)targetObject).getCommitTime();
                    }
                    repositoryTags2.add(new RepositoryTag(tag.getName(), this.commitDate(timestamp)));
                }
            }
            repositoryTags = new RepositoryTags(repositoryTags2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                return RepositoryTags.empty();
            }
        }
        git.close();
        return repositoryTags;
    }

    private Branches branches(Repository repository) {
        Branches branches;
        Git git = new Git(repository);
        try {
            branches = new Branches(git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call().stream().map(Ref::getName).toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                return Branches.empty();
            }
        }
        git.close();
        return branches;
    }

    private Commits commits(Repository repository) {
        Commits commits;
        ArrayList<Commit> commits2 = new ArrayList<Commit>(1000);
        Git git = new Git(repository);
        try {
            Iterable logCommits = git.log().add((AnyObjectId)repository.resolve(repository.getFullBranch())).setRevFilter(RevFilter.NO_MERGES).call();
            LocalDate commitsSince = this.commitsSince();
            for (RevCommit commit : logCommits) {
                String email;
                LocalDate commitDate = this.commitDate(commit.getCommitTime()).toLocalDate();
                if (!commitDate.isAfter(commitsSince) && !commitDate.isEqual(commitsSince) || (email = commit.getAuthorIdent().getEmailAddress()) == null || email.isBlank()) continue;
                commits2.add(this.commit(repository, commit));
            }
            commits = new Commits(commits2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                return Commits.empty();
            }
        }
        git.close();
        return commits;
    }

    private Commit commit(Repository repository, RevCommit commit) throws IOException {
        RevCommit parent = commit.getParentCount() > 0 ? commit.getParent(0) : null;
        int added = 0;
        int deleted = 0;
        HashSet<String> addedFiles = new HashSet<String>();
        HashSet<String> deletedFiles = new HashSet<String>();
        HashSet<String> changedFiles = new HashSet<String>();
        try (DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);){
            diffFormatter.setRepository(repository);
            diffFormatter.setDiffComparator(RawTextComparator.DEFAULT);
            diffFormatter.setContext(0);
            List diffEntries = diffFormatter.scan((AnyObjectId)parent, (AnyObjectId)commit);
            for (DiffEntry entry : diffEntries) {
                String path = entry.getChangeType() == DiffEntry.ChangeType.DELETE ? entry.getOldPath() : entry.getNewPath();
                if (entry.getChangeType() == DiffEntry.ChangeType.MODIFY || entry.getChangeType() == DiffEntry.ChangeType.RENAME) {
                    changedFiles.add(path);
                } else if (entry.getChangeType() == DiffEntry.ChangeType.ADD || entry.getChangeType() == DiffEntry.ChangeType.COPY) {
                    addedFiles.add(path);
                } else if (entry.getChangeType() == DiffEntry.ChangeType.DELETE) {
                    deletedFiles.add(path);
                }
                FileHeader fileHeader = diffFormatter.toFileHeader(entry);
                List hunks = fileHeader.getHunks();
                for (HunkHeader hunk : hunks) {
                    EditList edits = hunk.toEditList();
                    for (Edit edit : edits) {
                        switch (edit.getType()) {
                            case INSERT: {
                                added += edit.getLengthB();
                                break;
                            }
                            case DELETE: {
                                deleted += edit.getLengthA();
                                break;
                            }
                            case REPLACE: {
                                deleted += edit.getLengthA();
                                added += edit.getLengthB();
                                break;
                            }
                        }
                    }
                }
            }
        }
        return new Commit(commit.getId().getName(), this.commitDate(commit.getCommitTime()), commit.getShortMessage(), new CommitAuthor(commit.getAuthorIdent().getName(), commit.getAuthorIdent().getEmailAddress()), new CommitChanges(new CommitLinesChanges(added, deleted), new CommitFilesChanges(addedFiles.size(), deletedFiles.size(), changedFiles.size())));
    }

    private LocalDate commitsSince() {
        String last = System.getProperty("naikan.commits.last");
        if (last != null) {
            LocalDate now = LocalDate.now();
            Pattern pattern = Pattern.compile("(\\d+)([dwmy])");
            Matcher matcher = pattern.matcher(last);
            if (matcher.matches()) {
                int value = Integer.parseInt(matcher.group(1));
                char unit = matcher.group(2).charAt(0);
                switch (unit) {
                    case 'd': {
                        return now.minusDays(value);
                    }
                    case 'w': {
                        return now.minusWeeks(value);
                    }
                    case 'm': {
                        return now.minusMonths(value);
                    }
                    case 'y': {
                        return now.minusYears(value);
                    }
                }
            }
        }
        return LocalDate.MIN;
    }

    @Override
    public boolean support(Class<?> clazz) {
        return com.enofex.naikan.model.Repository.class.isAssignableFrom(clazz);
    }
}

