/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.maven.provider.pom;

import com.enofex.naikan.maven.provider.pom.PomProvider;
import com.enofex.naikan.model.Bom;
import com.enofex.naikan.model.Integration;
import com.enofex.naikan.model.Integrations;
import com.enofex.naikan.model.Tags;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

public final class IntegrationsProvider
extends PomProvider<Integrations> {
    @Override
    public Integrations provide(MavenSession session, MavenProject project, Bom existingBom) {
        ArrayList<Integration> integrations = new ArrayList<Integration>(5);
        this.scm(project, integrations);
        this.ciManagement(project, integrations);
        this.site(project, integrations);
        this.repository(project, integrations);
        this.snapshotRepository(project, integrations);
        return new Integrations(integrations);
    }

    private void scm(MavenProject project, List<Integration> integrations) {
        Scm scm = project.getScm();
        if (scm != null) {
            integrations.add(new Integration("SCM", scm.getUrl(), "The SCM of the project.", Tags.of((String[])new String[]{"SCM"})));
        }
    }

    private void ciManagement(MavenProject project, List<Integration> integrations) {
        CiManagement ciManagement = project.getCiManagement();
        if (ciManagement != null) {
            integrations.add(new Integration(ciManagement.getSystem(), ciManagement.getUrl(), "The CI system of the project.", Tags.of((String[])new String[]{"CI"})));
        }
    }

    private void site(MavenProject project, List<Integration> integrations) {
        DistributionManagement distributionManagement = project.getDistributionManagement();
        if (distributionManagement != null && distributionManagement.getSite() != null) {
            integrations.add(new Integration(distributionManagement.getSite().getName(), distributionManagement.getSite().getUrl(), null, Tags.of((String[])new String[]{"Site"})));
        }
    }

    private void repository(MavenProject project, List<Integration> integrations) {
        DistributionManagement distributionManagement = project.getDistributionManagement();
        if (distributionManagement != null && distributionManagement.getRepository() != null) {
            integrations.add(new Integration(distributionManagement.getRepository().getName(), distributionManagement.getRepository().getUrl(), "Deployment remote repository for this project.", Tags.of((String[])new String[]{"Distribution Management"})));
        }
    }

    private void snapshotRepository(MavenProject project, List<Integration> integrations) {
        DistributionManagement distributionManagement = project.getDistributionManagement();
        if (distributionManagement != null && distributionManagement.getSnapshotRepository() != null) {
            integrations.add(new Integration(distributionManagement.getSnapshotRepository().getName(), distributionManagement.getSnapshotRepository().getUrl(), "Deployment remote snapshot repository for this project.", Tags.of((String[])new String[]{"Snapshot Distribution Management"})));
        }
    }

    @Override
    public boolean support(Class<?> clazz) {
        return Integrations.class.isAssignableFrom(clazz);
    }
}

