/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model;

import com.enofex.naikan.model.BomSchema;
import com.enofex.naikan.model.Contacts;
import com.enofex.naikan.model.Deployments;
import com.enofex.naikan.model.Developers;
import com.enofex.naikan.model.Documentations;
import com.enofex.naikan.model.Environments;
import com.enofex.naikan.model.Integrations;
import com.enofex.naikan.model.Licenses;
import com.enofex.naikan.model.Organization;
import com.enofex.naikan.model.Project;
import com.enofex.naikan.model.Repository;
import com.enofex.naikan.model.Tags;
import com.enofex.naikan.model.Teams;
import com.enofex.naikan.model.Technologies;
import java.time.LocalDateTime;

public record Bom(String id, String bomFormat, String specVersion, LocalDateTime timestamp, Project project, Organization organization, Environments environments, Teams teams, Developers developers, Contacts contacts, Technologies technologies, Licenses licenses, Documentations documentations, Integrations integrations, Tags tags, Deployments deployments, Repository repository) {
    public static final String BOM_FORMAT = "Naikan";

    public Bom {
        bomFormat = bomFormat != null ? bomFormat : BOM_FORMAT;
        specVersion = specVersion != null ? specVersion : BomSchema.VERSION_LATEST.version();
        timestamp = timestamp != null ? timestamp : LocalDateTime.now();
        environments = environments != null ? environments : Environments.empty();
        teams = teams != null ? teams : Teams.empty();
        developers = developers != null ? developers : Developers.empty();
        contacts = contacts != null ? contacts : Contacts.empty();
        technologies = technologies != null ? technologies : Technologies.empty();
        licenses = licenses != null ? licenses : Licenses.empty();
        documentations = documentations != null ? documentations : Documentations.empty();
        integrations = integrations != null ? integrations : Integrations.empty();
        tags = tags != null ? tags : Tags.empty();
        deployments = deployments != null ? deployments : Deployments.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private String id;
        private String bomFormat;
        private String specVersion;
        private LocalDateTime timestamp;
        private Project project;
        private Organization organization;
        private Environments environments;
        private Teams teams;
        private Developers developers;
        private Contacts contacts;
        private Technologies technologies;
        private Licenses licenses;
        private Documentations documentations;
        private Integrations integrations;
        private Tags tags;
        private Deployments deployments;
        private Repository repository;

        private Builder() {
        }

        private Builder(Bom bom) {
            this.id = bom.id();
            this.bomFormat = bom.bomFormat();
            this.specVersion = bom.specVersion();
            this.timestamp = bom.timestamp();
            this.project = bom.project();
            this.organization = bom.organization();
            this.teams = bom.teams();
            this.developers = bom.developers();
            this.contacts = bom.contacts();
            this.technologies = bom.technologies();
            this.licenses = bom.licenses();
            this.documentations = bom.documentations();
            this.integrations = bom.integrations();
            this.tags = bom.tags();
            this.deployments = bom.deployments();
            this.repository = bom.repository();
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder bomFormat(String bomFormat) {
            this.bomFormat = bomFormat;
            return this;
        }

        public Builder specVersion(String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        public Builder timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder project(Project project) {
            this.project = project;
            return this;
        }

        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public Builder environments(Environments environments) {
            this.environments = environments;
            return this;
        }

        public Builder teams(Teams teams) {
            this.teams = teams;
            return this;
        }

        public Builder developers(Developers developers) {
            this.developers = developers;
            return this;
        }

        public Builder contacts(Contacts contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder technologies(Technologies technologies) {
            this.technologies = technologies;
            return this;
        }

        public Builder licenses(Licenses licenses) {
            this.licenses = licenses;
            return this;
        }

        public Builder documentations(Documentations documentations) {
            this.documentations = documentations;
            return this;
        }

        public Builder integrations(Integrations integrations) {
            this.integrations = integrations;
            return this;
        }

        public Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public Builder deployments(Deployments deployments) {
            this.deployments = deployments;
            return this;
        }

        public Builder repository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Bom build() {
            return new Bom(this.id, this.bomFormat, this.specVersion, this.timestamp, this.project, this.organization, this.environments, this.teams, this.developers, this.contacts, this.technologies, this.licenses, this.documentations, this.integrations, this.tags, this.deployments, this.repository);
        }
    }
}

