/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class BomSchema {
    public static final String NS_BOM_10 = "https://enofex.github.io/naikan/schema/bom/1.0";
    public static final Version VERSION_LATEST = Version.VERSION_10;

    public JsonSchema jsonSchema(Version schemaVersion, ObjectMapper mapper) throws IOException {
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        Map<String, String> offlineMappings = Map.of("https://enofex.github.io/naikan/schema/bom-1.0.schema.json", this.getClass().getClassLoader().getResource(this.schemaFile(schemaVersion)).toExternalForm());
        config.setUriMappings(offlineMappings);
        JsonNode schemaNode = mapper.readTree(this.jsonSchemaAsStream(schemaVersion));
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersionDetector.detect((JsonNode)schemaNode));
        return factory.getSchema(schemaNode, config);
    }

    private InputStream jsonSchemaAsStream(Version schemaVersion) {
        return this.getClass().getClassLoader().getResourceAsStream(this.schemaFile(schemaVersion));
    }

    private String schemaFile(Version schemaVersion) {
        if (Version.VERSION_10 == schemaVersion) {
            return "bom-1.0.schema.json";
        }
        return null;
    }

    public static enum Version {
        VERSION_10("https://enofex.github.io/naikan/schema/bom/1.0", "1.0");

        private final String namespace;
        private final String version;

        private Version(String namespace, String version) {
            this.namespace = namespace;
            this.version = version;
        }

        public String namespace() {
            return this.namespace;
        }

        public String version() {
            return this.version;
        }
    }
}

