/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model.module;

import com.enofex.naikan.model.module.NaikanModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;

public final class ObjectMapperFactory {
    private ObjectMapperFactory() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new NaikanModule());
        mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule stringModule = new SimpleModule();
        stringModule.addSerializer((JsonSerializer)new TrimStringSerializer());
        mapper.registerModule((Module)stringModule);
        return mapper;
    }

    private static final class TrimStringSerializer
    extends StdScalarSerializer<Object> {
        private static final long serialVersionUID = 1L;

        TrimStringSerializer() {
            super(String.class, false);
        }

        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value != null) {
                gen.writeString(value.trim().replace("\r\n", " ").replace("\n", " ").replace("\t", " ").replace("\r", " ").replaceAll(" +", " "));
            }
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value instanceof String) {
                this.serialize((String)value, gen, provider);
            }
        }
    }
}

