/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model.serializer;

import com.enofex.naikan.model.BomSchema;
import com.enofex.naikan.model.serializer.Serializer;
import java.util.ServiceLoader;

public final class SerializerFactory {
    private SerializerFactory() {
    }

    public static Serializer newJsonSerializer() {
        return SerializerFactory.loadJsonSerializer(BomSchema.VERSION_LATEST);
    }

    public static Serializer newJsonSerializer(BomSchema.Version version) {
        return SerializerFactory.loadJsonSerializer(version);
    }

    private static Serializer loadJsonSerializer(BomSchema.Version version) {
        ServiceLoader<Serializer> serializers = ServiceLoader.load(Serializer.class);
        for (Serializer serializer : serializers) {
            if (!serializer.supports("json") || serializer.getSchemaVersion() != version) continue;
            return serializer;
        }
        return null;
    }
}

