/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model.serializer.json;

import com.enofex.naikan.model.Bom;
import com.enofex.naikan.model.BomSchema;
import com.enofex.naikan.model.module.ObjectMapperFactory;
import com.enofex.naikan.model.serializer.SerializerException;
import com.enofex.naikan.model.serializer.json.JsonSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;

abstract class AbstractJsonSerializer
extends BomSchema
implements JsonSerializer {
    private final ObjectMapper mapper = ObjectMapperFactory.newObjectMapper();
    private final DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();

    AbstractJsonSerializer() {
        this.prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }

    ObjectMapper mapper() {
        return this.mapper;
    }

    String toJson(Bom bom, boolean prettyPrint) throws SerializerException {
        try {
            if (prettyPrint) {
                return this.mapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)bom);
            }
            return this.mapper.writeValueAsString((Object)bom);
        }
        catch (JsonProcessingException e) {
            throw new SerializerException(e);
        }
    }

    Bom injectBomFormatAndSpecVersion(Bom bom) throws SerializerException {
        try {
            Field field = Bom.class.getDeclaredField("bomFormat");
            field.setAccessible(true);
            field.set(bom, "Naikan");
            field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, this.getSchemaVersion().version());
            return bom;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new SerializerException(e);
        }
    }

    Bom modifyBom(Bom bom) {
        Bom modifiedBom = null;
        try {
            modifiedBom = this.injectBomFormatAndSpecVersion(bom);
        }
        catch (SerializerException serializerException) {
            // empty catch block
        }
        return modifiedBom != null ? modifiedBom : bom;
    }
}

