/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model.serializer.json;

import com.enofex.naikan.model.Bom;
import com.enofex.naikan.model.BomSchema;
import com.enofex.naikan.model.serializer.SerializerException;
import com.enofex.naikan.model.serializer.json.AbstractJsonSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public final class JsonSerializer10
extends AbstractJsonSerializer {
    @Override
    public BomSchema.Version getSchemaVersion() {
        return BomSchema.Version.VERSION_10;
    }

    @Override
    public File toFile(Bom bom, String fileName) {
        return this.toFile(bom, fileName, true);
    }

    @Override
    public File toFile(Bom bom, String fileName, boolean prettyPrint) {
        File file;
        FileWriter writer = new FileWriter(fileName);
        try {
            writer.write(this.toJson(this.modifyBom(bom), prettyPrint));
            file = new File(fileName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SerializerException | IOException e) {
                return null;
            }
        }
        writer.close();
        return file;
    }

    @Override
    public JsonNode toJsonNode(Bom bom) {
        try {
            return this.mapper().readTree(this.toJson(this.modifyBom(bom), false));
        }
        catch (SerializerException | JsonProcessingException e) {
            return null;
        }
    }

    @Override
    public String toJsonString(Bom bom) {
        return this.toString(bom);
    }

    @Override
    public String toString(Bom bom) {
        try {
            return this.toJson(this.modifyBom(bom), false);
        }
        catch (SerializerException e) {
            return "";
        }
    }
}

