/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.naikan.model.validator;

import com.enofex.naikan.model.Bom;
import com.enofex.naikan.model.BomSchema;
import com.enofex.naikan.model.module.ObjectMapperFactory;
import com.enofex.naikan.model.serializer.SerializerFactory;
import com.enofex.naikan.model.validator.ValidationException;
import com.enofex.naikan.model.validator.Validator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DefaultValidator
extends BomSchema
implements Validator {
    private final ObjectMapper mapper = ObjectMapperFactory.newObjectMapper();

    @Override
    public List<ValidationException> validate(File file) {
        return this.validate(file, BomSchema.VERSION_LATEST);
    }

    @Override
    public List<ValidationException> validate(File file, BomSchema.Version schemaVersion) {
        try {
            return this.validate(FileUtils.readFileToString((File)file, (String)StandardCharsets.UTF_8.name()), schemaVersion);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public List<ValidationException> validate(byte[] bomBytes) {
        return this.validate(bomBytes, BomSchema.VERSION_LATEST);
    }

    @Override
    public List<ValidationException> validate(byte[] bomBytes, BomSchema.Version schemaVersion) {
        return this.validate(new String(bomBytes), schemaVersion);
    }

    @Override
    public List<ValidationException> validate(Reader reader) {
        return this.validate(reader, BomSchema.VERSION_LATEST);
    }

    @Override
    public List<ValidationException> validate(Reader reader, BomSchema.Version schemaVersion) {
        try {
            return this.validate(IOUtils.toString((Reader)reader), schemaVersion);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public List<ValidationException> validate(InputStream inputStream) {
        return this.validate(inputStream, BomSchema.VERSION_LATEST);
    }

    @Override
    public List<ValidationException> validate(InputStream inputStream, BomSchema.Version schemaVersion) {
        try {
            return this.validate(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), schemaVersion);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public List<ValidationException> validate(String bomString, BomSchema.Version schemaVersion) {
        try {
            return this.validate(this.mapper.readTree(bomString), schemaVersion);
        }
        catch (JsonProcessingException e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public List<ValidationException> validate(String bomString) {
        try {
            return this.validate(this.mapper.readTree(bomString), BomSchema.VERSION_LATEST);
        }
        catch (JsonProcessingException e) {
            throw new ValidationException(e);
        }
    }

    public List<ValidationException> validate(JsonNode bomJson, BomSchema.Version schemaVersion) {
        try {
            return this.jsonSchema(schemaVersion, this.mapper).validate(this.mapper.readTree(bomJson.toString())).stream().map(message -> new ValidationException(message.getMessage())).toList();
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public boolean isValid(File file) {
        return this.validate(file).isEmpty();
    }

    @Override
    public boolean isValid(File file, BomSchema.Version schemaVersion) {
        return this.validate(file, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes) {
        return this.validate(bomBytes).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes, BomSchema.Version schemaVersion) {
        return this.validate(bomBytes, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(String bomString) {
        return this.validate(bomString).isEmpty();
    }

    @Override
    public boolean isValid(String bomString, BomSchema.Version schemaVersion) {
        return this.validate(bomString, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(Bom bom) {
        return this.validate(SerializerFactory.newJsonSerializer().toString(bom)).isEmpty();
    }

    @Override
    public boolean isValid(Bom bom, BomSchema.Version schemaVersion) {
        return this.validate(SerializerFactory.newJsonSerializer().toString(bom), schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader) {
        return this.validate(reader).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader, BomSchema.Version schemaVersion) {
        return this.validate(reader, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream) {
        return this.validate(inputStream).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream, BomSchema.Version schemaVersion) {
        return this.validate(inputStream, schemaVersion).isEmpty();
    }
}

