/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class Namespace {
    private static final Map<Key, JavaClasses> JAVA_CLASSES = new ConcurrentHashMap<Key, JavaClasses>();

    private Namespace() {
    }

    public static JavaClasses from(String namespace, IMPORT importOption) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(importOption);
        return switch (importOption) {
            case IMPORT.WITH_TESTS -> Namespace.withTests(namespace);
            case IMPORT.ONLY_TESTS -> Namespace.onlyTests(namespace);
            default -> Namespace.withoutTests(namespace);
        };
    }

    public static JavaClasses withoutTests(String namespace) {
        Objects.requireNonNull(namespace);
        return JAVA_CLASSES.computeIfAbsent(new Key(namespace, IMPORT.WITHOUT_TESTS), key -> new ClassFileImporter().withImportOption((ImportOption)new ImportOption.DoNotIncludeTests()).withImportOption((ImportOption)new ImportOption.DoNotIncludeJars()).importPackages(new String[]{namespace}));
    }

    public static JavaClasses withTests(String namespace) {
        Objects.requireNonNull(namespace);
        return JAVA_CLASSES.computeIfAbsent(new Key(namespace, IMPORT.WITH_TESTS), key -> new ClassFileImporter().withImportOption((ImportOption)new ImportOption.DoNotIncludeJars()).importPackages(new String[]{namespace}));
    }

    public static JavaClasses onlyTests(String namespace) {
        Objects.requireNonNull(namespace);
        return JAVA_CLASSES.computeIfAbsent(new Key(namespace, IMPORT.ONLY_TESTS), key -> new ClassFileImporter().withImportOption((ImportOption)new ImportOption.OnlyIncludeTests()).withImportOption((ImportOption)new ImportOption.DoNotIncludeJars()).importPackages(new String[]{namespace}));
    }

    public static enum IMPORT {
        WITHOUT_TESTS,
        WITH_TESTS,
        ONLY_TESTS;

    }

    private record Key(String namespace, IMPORT importOption) {
    }
}

