/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.configures;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.Configurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.Customizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class AbstractConfigurer
implements Configurer {
    private final ConfigurerContext configurerContext;
    private final Collection<TaikaiRule> rules;

    protected AbstractConfigurer(ConfigurerContext configurerContext) {
        this.configurerContext = Objects.requireNonNull(configurerContext);
        this.rules = new ArrayList<TaikaiRule>();
    }

    protected ConfigurerContext configurerContext() {
        return this.configurerContext;
    }

    protected <T extends Configurer> T addRule(TaikaiRule rule) {
        this.rules.add(rule);
        return (T)this;
    }

    protected <T extends Configurer> void disable(Class<T> clazz) {
        T configurer;
        if (clazz != null && (configurer = this.configurerContext.configurers().get(clazz)) != null) {
            configurer.clear();
        }
    }

    protected <T extends Configurer, C extends Configurer> C customizer(Customizer<T> customizer, Supplier<T> supplier) {
        Objects.requireNonNull(customizer);
        Objects.requireNonNull(supplier);
        customizer.customize(this.configurerContext.configurers().getOrApply((Configurer)supplier.get()));
        return (C)this;
    }

    @Override
    public Collection<TaikaiRule> rules() {
        return this.rules;
    }
}

