/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.configures;

import com.enofex.taikai.configures.Configurer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class Configurers
implements Iterable<Configurer> {
    private final Map<Class<? extends Configurer>, Configurer> configurers = new LinkedHashMap<Class<? extends Configurer>, Configurer>();

    public <C extends Configurer> C getOrApply(C configurer) {
        Objects.requireNonNull(configurer);
        Object existingConfigurer = this.get(configurer.getClass());
        return (C)(existingConfigurer != null ? existingConfigurer : this.apply(configurer));
    }

    private <C extends Configurer> C apply(C configurer) {
        this.add(configurer);
        return configurer;
    }

    private <C extends Configurer> void add(C configurer) {
        Class<?> clazz = configurer.getClass();
        this.configurers.putIfAbsent(clazz, configurer);
    }

    public <C extends Configurer> C get(Class<C> clazz) {
        return (C)this.configurers.get(clazz);
    }

    public Collection<Configurer> all() {
        return this.configurers.values();
    }

    @Override
    public Iterator<Configurer> iterator() {
        return this.configurers.values().iterator();
    }
}

