/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.internal;

import com.enofex.taikai.internal.Modifiers;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Collection;
import java.util.stream.Collectors;

public final class ArchConditions {
    private ArchConditions() {
    }

    public static ArchCondition<JavaMethod> notDeclareThrownExceptions() {
        return new ArchCondition<JavaMethod>("not declare thrown exceptions", new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                if (!method.getThrowsClause().isEmpty()) {
                    events.add(SimpleConditionEvent.violated((Object)method, (String)"Method %s declares thrown exceptions".formatted(method.getFullName())));
                }
            }
        };
    }

    public static ArchCondition<JavaField> notBePublicUnlessStatic() {
        return new ArchCondition<JavaField>("not be public", new Object[0]){

            public void check(JavaField field, ConditionEvents events) {
                if (!Modifiers.isFieldStatic(field) && Modifiers.isFieldPublic(field)) {
                    events.add(SimpleConditionEvent.violated((Object)field, (String)"Field %s in class %s is public".formatted(field.getName(), field.getOwner().getFullName())));
                }
            }
        };
    }

    public static ArchCondition<JavaClass> haveFieldOfType(final String typeName) {
        return new ArchCondition<JavaClass>("have a field of type %s".formatted(typeName), new Object[0]){

            public void check(JavaClass item, ConditionEvents events) {
                boolean hasFieldOfType = item.getAllFields().stream().anyMatch(field -> field.getRawType().getName().equals(typeName));
                if (!hasFieldOfType) {
                    events.add(SimpleConditionEvent.violated((Object)item, (String)"%s does not have a field of type %s".formatted(item.getName(), typeName)));
                }
            }
        };
    }

    public static ArchCondition<JavaField> hasFieldModifiers(final Collection<JavaModifier> requiredModifiers) {
        return new ArchCondition<JavaField>("has field modifiers", new Object[0]){

            public void check(JavaField field, ConditionEvents events) {
                if (!field.getModifiers().containsAll(requiredModifiers)) {
                    events.add(SimpleConditionEvent.violated((Object)field, (String)"Field %s in class %s is missing one of this %s modifier".formatted(field.getName(), field.getOwner().getFullName(), requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))));
                }
            }
        };
    }

    public static ArchCondition<JavaMethod> hasMethodsModifiers(final Collection<JavaModifier> requiredModifiers) {
        return new ArchCondition<JavaMethod>("has method modifiers", new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                if (!method.getModifiers().containsAll(requiredModifiers)) {
                    events.add(SimpleConditionEvent.violated((Object)method, (String)"Method %s in class %s is missing one of this %s modifier".formatted(method.getName(), method.getOwner().getFullName(), requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))));
                }
            }
        };
    }

    public static ArchCondition<JavaClass> hasClassModifiers(final Collection<JavaModifier> requiredModifiers) {
        return new ArchCondition<JavaClass>("has class modifiers", new Object[0]){

            public void check(JavaClass clazz, ConditionEvents events) {
                if (!clazz.getModifiers().containsAll(requiredModifiers)) {
                    events.add(SimpleConditionEvent.violated((Object)clazz, (String)"Class %s is missing one of this %s modifier".formatted(clazz.getName(), requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))));
                }
            }
        };
    }
}

