/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.internal;

import com.enofex.taikai.internal.Modifiers;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import java.util.Collection;

public final class DescribedPredicates {
    private DescribedPredicates() {
    }

    public static DescribedPredicate<CanBeAnnotated> annotatedWith(final String annotation, final boolean isMetaAnnotated) {
        return new DescribedPredicate<CanBeAnnotated>("annotated with %s".formatted(annotation), new Object[0]){

            public boolean test(CanBeAnnotated canBeAnnotated) {
                return isMetaAnnotated ? canBeAnnotated.isMetaAnnotatedWith(annotation) : canBeAnnotated.isAnnotatedWith(annotation);
            }
        };
    }

    public static DescribedPredicate<CanBeAnnotated> annotatedWithAll(final Collection<String> annotations, final boolean isMetaAnnotated) {
        return new DescribedPredicate<CanBeAnnotated>("annotated with all of %s".formatted(annotations), new Object[0]){

            public boolean test(CanBeAnnotated canBeAnnotated) {
                return annotations.stream().allMatch(annotation -> isMetaAnnotated ? canBeAnnotated.isMetaAnnotatedWith(annotation) : canBeAnnotated.isAnnotatedWith(annotation));
            }
        };
    }

    public static DescribedPredicate<JavaClass> areFinal() {
        return new DescribedPredicate<JavaClass>("are final", new Object[0]){

            public boolean test(JavaClass javaClass) {
                return Modifiers.isClassFinal(javaClass);
            }
        };
    }
}

