/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.internal.Modifiers;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.regex.Pattern;

final class ConstantNaming {
    private static final Pattern CONSTANT_NAME_PATTERN = Pattern.compile("^[A-Z][A-Z0-9_]*$");

    private ConstantNaming() {
    }

    static ArchCondition<JavaField> shouldFollowConstantNamingConventions() {
        return new ArchCondition<JavaField>("follow constant naming convention", new Object[0]){

            public void check(JavaField field, ConditionEvents events) {
                if (!(Modifiers.isFieldSynthetic(field) || "serialVersionUID".equals(field.getName()) || CONSTANT_NAME_PATTERN.matcher(field.getName()).matches())) {
                    events.add(SimpleConditionEvent.violated((Object)field, (String)"Constant %s in class %s does not follow the naming convention".formatted(field.getName(), field.getOwner().getName())));
                }
            }
        };
    }
}

