/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;

final class Deprecations {
    private Deprecations() {
    }

    static ArchCondition<JavaClass> notUseDeprecatedAPIs() {
        return new ArchCondition<JavaClass>("not use deprecated APIs", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                javaClass.getFieldAccessesFromSelf().stream().filter(access -> ((AccessTarget.FieldAccessTarget)access.getTarget()).isAnnotatedWith(Deprecated.class)).forEach(access -> events.add(SimpleConditionEvent.violated((Object)access.getTarget(), (String)"Field %s in class %s is deprecated and is being accessed by %s".formatted(((AccessTarget.FieldAccessTarget)access.getTarget()).getName(), ((AccessTarget.FieldAccessTarget)access.getTarget()).getOwner().getName(), javaClass.getName()))));
                javaClass.getMethodCallsFromSelf().stream().filter(method -> !((AccessTarget.MethodCallTarget)method.getTarget()).getName().equals(Object.class.getName())).filter(method -> !((AccessTarget.MethodCallTarget)method.getTarget()).getName().equals(Enum.class.getName())).filter(method -> ((AccessTarget.MethodCallTarget)method.getTarget()).isAnnotatedWith(Deprecated.class) || ((AccessTarget.MethodCallTarget)method.getTarget()).getRawReturnType().isAnnotatedWith(Deprecated.class) || ((AccessTarget.MethodCallTarget)method.getTarget()).getParameterTypes().stream().anyMatch(Deprecations::isDeprecated)).forEach(method -> events.add(SimpleConditionEvent.violated((Object)method, (String)"Method %s used in class %s is deprecated".formatted(method.getName(), javaClass.getName()))));
                javaClass.getConstructorCallsFromSelf().stream().filter(constructor -> ((AccessTarget.ConstructorCallTarget)constructor.getTarget()).isAnnotatedWith(Deprecated.class) || ((AccessTarget.ConstructorCallTarget)constructor.getTarget()).getParameterTypes().stream().anyMatch(Deprecations::isDeprecated)).forEach(constructor -> events.add(SimpleConditionEvent.violated((Object)constructor, (String)"Constructor %s in class %s uses deprecated APIs".formatted(((AccessTarget.ConstructorCallTarget)constructor.getTarget()).getFullName(), javaClass.getName()))));
                javaClass.getDirectDependenciesFromSelf().stream().filter(dependency -> dependency.getTargetClass().isAnnotatedWith(Deprecated.class)).forEach(dependency -> events.add(SimpleConditionEvent.violated((Object)dependency.getTargetClass(), (String)"Class %s depends on deprecated class %s".formatted(javaClass.getName(), dependency.getTargetClass().getName()))));
            }
        }.as("no usage of deprecated APIs", new Object[0]);
    }

    private static boolean isDeprecated(JavaType javaType) {
        return javaType.toErasure().isAnnotatedWith(Deprecated.class);
    }
}

