/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.TaikaiException;
import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.library.dependencies.SlicesRuleDefinition;

public class ImportsConfigurer
extends AbstractConfigurer {
    ImportsConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public ImportsConfigurer shouldNotImport(String packageIdentifier) {
        return this.shouldNotImport(packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ImportsConfigurer shouldNotImport(String packageIdentifier, TaikaiRule.Configuration configuration) {
        return (ImportsConfigurer)this.addRule(TaikaiRule.of((ArchRule)((ClassesShouldConjunction)ArchRuleDefinition.noClasses().should().accessClassesThat().resideInAPackage(packageIdentifier)).as("No classes should have imports from package %s".formatted(packageIdentifier)), configuration));
    }

    public ImportsConfigurer shouldNotImport(String regex, String notImportClassesRegex) {
        return this.shouldNotImport(regex, notImportClassesRegex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ImportsConfigurer shouldNotImport(String regex, String notImportClassesRegex, TaikaiRule.Configuration configuration) {
        return (ImportsConfigurer)this.addRule(TaikaiRule.of((ArchRule)((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().haveNameMatching(regex)).should().accessClassesThat().haveNameMatching(notImportClassesRegex)).as("No classes that have name matching %s should have imports %s".formatted(regex, notImportClassesRegex)), configuration));
    }

    public ImportsConfigurer shouldHaveNoCycles() {
        return this.shouldHaveNoCycles(null);
    }

    public ImportsConfigurer shouldHaveNoCycles(TaikaiRule.Configuration configuration) {
        String namespace;
        String string = configuration != null ? configuration.namespace() : (namespace = this.configurerContext() != null ? this.configurerContext().namespace() : null);
        if (namespace == null) {
            throw new TaikaiException("Namespace is not set");
        }
        return (ImportsConfigurer)this.addRule(TaikaiRule.of((ArchRule)SlicesRuleDefinition.slices().matching(namespace + ".(*)..").should().beFreeOfCycles().as("Namespace %s should be free of cycles".formatted(namespace)), configuration));
    }

    public static final class Disableable
    extends ImportsConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public ImportsConfigurer disable() {
            this.disable(ImportsConfigurer.class);
            return this;
        }
    }
}

