/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.Customizer;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.internal.ArchConditions;
import com.enofex.taikai.internal.DescribedPredicates;
import com.enofex.taikai.java.Deprecations;
import com.enofex.taikai.java.HashCodeAndEquals;
import com.enofex.taikai.java.ImportsConfigurer;
import com.enofex.taikai.java.NamingConfigurer;
import com.enofex.taikai.java.NoSystemOutOrErr;
import com.enofex.taikai.java.ProtectedMembers;
import com.enofex.taikai.java.SerialVersionUID;
import com.enofex.taikai.java.UtilityClasses;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.stream.Collectors;

public class JavaConfigurer
extends AbstractConfigurer {
    public JavaConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public Disableable imports(Customizer<ImportsConfigurer.Disableable> customizer) {
        return (Disableable)this.customizer(customizer, () -> new ImportsConfigurer.Disableable(this.configurerContext()));
    }

    public Disableable naming(Customizer<NamingConfigurer.Disableable> customizer) {
        return (Disableable)this.customizer(customizer, () -> new NamingConfigurer.Disableable(this.configurerContext()));
    }

    public JavaConfigurer utilityClassesShouldBeFinalAndHavePrivateConstructor() {
        return this.utilityClassesShouldBeFinalAndHavePrivateConstructor(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer utilityClassesShouldBeFinalAndHavePrivateConstructor(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)UtilityClasses.utilityClasses().should(com.tngtech.archunit.lang.conditions.ArchConditions.beFinal()).andShould(UtilityClasses.havePrivateConstructor()).as("Utility classes should be final and have a private constructor"), configuration));
    }

    public JavaConfigurer methodsShouldNotDeclareGenericExceptions() {
        return this.methodsShouldNotDeclareGenericExceptions(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldNotDeclareGenericExceptions(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)((MethodsShouldConjunction)ArchRuleDefinition.methods().should().notDeclareThrowableOfType(Exception.class)).orShould().notDeclareThrowableOfType(RuntimeException.class)).as("Methods should not declare generic Exception or RuntimeException"), configuration));
    }

    public JavaConfigurer methodsShouldNotDeclareException(String regex, Class<? extends Throwable> clazz) {
        return this.methodsShouldNotDeclareException(regex, clazz.getName(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldNotDeclareException(String regex, Class<? extends Throwable> clazz, TaikaiRule.Configuration configuration) {
        return this.methodsShouldNotDeclareException(regex, clazz.getName(), configuration);
    }

    public JavaConfigurer methodsShouldNotDeclareException(String regex, String typeName) {
        return this.methodsShouldNotDeclareException(regex, typeName, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldNotDeclareException(String regex, String typeName, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().haveNameMatching(regex)).should().notDeclareThrowableOfType(typeName)).as("Methods have name matching %s should not declare %s".formatted(regex, typeName)), configuration));
    }

    public JavaConfigurer methodsShouldBeAnnotatedWith(String regex, Class<? extends Annotation> annotationType) {
        return this.methodsShouldBeAnnotatedWith(regex, annotationType.getName(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldBeAnnotatedWith(String regex, Class<? extends Annotation> annotationType, TaikaiRule.Configuration configuration) {
        return this.methodsShouldBeAnnotatedWith(regex, annotationType.getName(), configuration);
    }

    public JavaConfigurer methodsShouldBeAnnotatedWith(String regex, String annotationType) {
        return this.methodsShouldBeAnnotatedWith(regex, annotationType, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldBeAnnotatedWith(String regex, String annotationType, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().haveNameMatching(regex)).should().beMetaAnnotatedWith(annotationType)).as("Methods have name matching %s should be annotated with %s".formatted(regex, annotationType)), configuration));
    }

    public JavaConfigurer methodsShouldBeAnnotatedWithAll(Class<? extends Annotation> annotationType, Collection<Class<? extends Annotation>> requiredAnnotationTypes) {
        return this.methodsShouldBeAnnotatedWithAll(annotationType.getName(), requiredAnnotationTypes.stream().map(Class::getName).toList(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldBeAnnotatedWithAll(Class<? extends Annotation> annotationType, Collection<Class<? extends Annotation>> requiredAnnotationTypes, TaikaiRule.Configuration configuration) {
        return this.methodsShouldBeAnnotatedWithAll(annotationType.getName(), requiredAnnotationTypes.stream().map(Class::getName).toList(), configuration);
    }

    public JavaConfigurer methodsShouldBeAnnotatedWithAll(String annotationType, Collection<String> requiredAnnotationTypes) {
        return this.methodsShouldBeAnnotatedWithAll(annotationType, requiredAnnotationTypes, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldBeAnnotatedWithAll(String annotationType, Collection<String> requiredAnnotationTypes, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areMetaAnnotatedWith(annotationType)).should((ArchCondition)com.tngtech.archunit.lang.conditions.ArchConditions.be(DescribedPredicates.annotatedWithAll(requiredAnnotationTypes, true))).as("Methods annotated with %s should be annotated with %s".formatted(annotationType, String.join((CharSequence)", ", requiredAnnotationTypes))), configuration));
    }

    public JavaConfigurer methodsShouldHaveModifiers(String regex, Collection<JavaModifier> requiredModifiers) {
        return this.methodsShouldHaveModifiers(regex, requiredModifiers, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldHaveModifiers(String regex, Collection<JavaModifier> requiredModifiers, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().haveNameMatching(regex)).should(ArchConditions.hasMethodsModifiers(requiredModifiers)).as("Methods have name matching %s should have all of this modifiers %s".formatted(regex, requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))), configuration));
    }

    public JavaConfigurer methodsShouldHaveModifiersForClass(String regex, Collection<JavaModifier> requiredModifiers) {
        return this.methodsShouldHaveModifiersForClass(regex, requiredModifiers, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer methodsShouldHaveModifiersForClass(String regex, Collection<JavaModifier> requiredModifiers, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areDeclaredIn(regex)).should(ArchConditions.hasMethodsModifiers(requiredModifiers)).as("Methods in class %s should have all of this modifiers %s".formatted(regex, requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))), configuration));
    }

    public JavaConfigurer noUsageOfDeprecatedAPIs() {
        return this.noUsageOfDeprecatedAPIs(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer noUsageOfDeprecatedAPIs(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().should(Deprecations.notUseDeprecatedAPIs()).as("Classes should not use deprecated APIs"), configuration));
    }

    public JavaConfigurer classesShouldResideInPackage(String packageIdentifier) {
        return this.classesShouldResideInPackage(packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldResideInPackage(String packageIdentifier, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().should().resideInAPackage(packageIdentifier).as("Package names should match %s".formatted(packageIdentifier)), configuration));
    }

    public JavaConfigurer classesShouldResideInPackage(String regex, String packageIdentifier) {
        return this.classesShouldResideInPackage(regex, packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldResideInPackage(String regex, String packageIdentifier, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should().resideInAPackage(packageIdentifier).as("Classes have name matching %s should reside in package %s".formatted(regex, packageIdentifier)), configuration));
    }

    public JavaConfigurer classesShouldResideOutsidePackage(String regex, String packageIdentifier) {
        return this.classesShouldResideOutsidePackage(regex, packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldResideOutsidePackage(String regex, String packageIdentifier, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should().resideOutsideOfPackage(packageIdentifier).as("Classes have name matching %s should reside outside package %s".formatted(regex, packageIdentifier)), configuration));
    }

    public JavaConfigurer classesShouldBeAnnotatedWithAll(Class<? extends Annotation> annotationType, Collection<Class<? extends Annotation>> requiredAnnotationTypes) {
        return this.classesShouldBeAnnotatedWithAll(annotationType.getName(), requiredAnnotationTypes.stream().map(Class::getName).toList(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldBeAnnotatedWithAll(Class<? extends Annotation> annotationType, Collection<Class<? extends Annotation>> requiredAnnotationTypes, TaikaiRule.Configuration configuration) {
        return this.classesShouldBeAnnotatedWithAll(annotationType.getName(), requiredAnnotationTypes.stream().map(Class::getName).toList(), configuration);
    }

    public JavaConfigurer classesShouldBeAnnotatedWithAll(String annotationType, Collection<String> requiredAnnotationTypes) {
        return this.classesShouldBeAnnotatedWithAll(annotationType, requiredAnnotationTypes, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldBeAnnotatedWithAll(String annotationType, Collection<String> requiredAnnotationTypes, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areMetaAnnotatedWith(annotationType)).should((ArchCondition)com.tngtech.archunit.lang.conditions.ArchConditions.be(DescribedPredicates.annotatedWithAll(requiredAnnotationTypes, true))).as("Classes annotated with %s should be annotated with %s".formatted(annotationType, String.join((CharSequence)", ", requiredAnnotationTypes))), configuration));
    }

    public JavaConfigurer classesShouldBeAnnotatedWith(String regex, Class<? extends Annotation> annotationType) {
        return this.classesShouldBeAnnotatedWith(regex, annotationType.getName(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldBeAnnotatedWith(String regex, Class<? extends Annotation> annotationType, TaikaiRule.Configuration configuration) {
        return this.classesShouldBeAnnotatedWith(regex, annotationType.getName(), configuration);
    }

    public JavaConfigurer classesShouldBeAnnotatedWith(String regex, String annotationType) {
        return this.classesShouldBeAnnotatedWith(regex, annotationType, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldBeAnnotatedWith(String regex, String annotationType, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should().beMetaAnnotatedWith(annotationType).as("Classes have name matching %s should be annotated with %s".formatted(regex, annotationType)), configuration));
    }

    public JavaConfigurer classesShouldNotBeAnnotatedWith(String regex, Class<? extends Annotation> annotationType) {
        return this.classesShouldNotBeAnnotatedWith(regex, annotationType.getName(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldNotBeAnnotatedWith(String regex, Class<? extends Annotation> annotationType, TaikaiRule.Configuration configuration) {
        return this.classesShouldNotBeAnnotatedWith(regex, annotationType.getName(), configuration);
    }

    public JavaConfigurer classesShouldNotBeAnnotatedWith(String regex, String annotationType) {
        return this.classesShouldNotBeAnnotatedWith(regex, annotationType, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldNotBeAnnotatedWith(String regex, String annotationType, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should().notBeMetaAnnotatedWith(annotationType).as("Classes have name matching %s should not be annotated with %s".formatted(regex, annotationType)), configuration));
    }

    public JavaConfigurer classesAnnotatedWithShouldResideInPackage(Class<? extends Annotation> annotationType, String packageIdentifier) {
        return this.classesAnnotatedWithShouldResideInPackage(annotationType.getName(), packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesAnnotatedWithShouldResideInPackage(Class<? extends Annotation> annotationType, String packageIdentifier, TaikaiRule.Configuration configuration) {
        return this.classesAnnotatedWithShouldResideInPackage(annotationType.getName(), packageIdentifier, configuration);
    }

    public JavaConfigurer classesAnnotatedWithShouldResideInPackage(String annotationType, String packageIdentifier) {
        return this.classesAnnotatedWithShouldResideInPackage(annotationType, packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesAnnotatedWithShouldResideInPackage(String annotationType, String packageIdentifier, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areMetaAnnotatedWith(annotationType)).should().resideInAPackage(packageIdentifier).as("Classes annotated with %s should reside in package %s".formatted(annotationType, packageIdentifier)), configuration));
    }

    public JavaConfigurer classesShouldImplementHashCodeAndEquals() {
        return this.classesShouldImplementHashCodeAndEquals(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldImplementHashCodeAndEquals(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().should(HashCodeAndEquals.implementHashCodeAndEquals()).as("Classes should implement hashCode and equals"), configuration));
    }

    public JavaConfigurer classesShouldBeAssignableTo(String regex, Class<?> clazz) {
        return this.classesShouldBeAssignableTo(regex, clazz.getName(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldBeAssignableTo(String regex, Class<?> clazz, TaikaiRule.Configuration configuration) {
        return this.classesShouldBeAssignableTo(regex, clazz.getName(), configuration);
    }

    public JavaConfigurer classesShouldBeAssignableTo(String regex, String typeName) {
        return this.classesShouldBeAssignableTo(regex, typeName, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldBeAssignableTo(String regex, String typeName, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith(regex)).should().beAssignableTo(typeName).as("Classes have name matching %s should be assignable to %s".formatted(regex, typeName)), configuration));
    }

    public JavaConfigurer classesShouldImplement(String regex, Class<?> clazz) {
        return this.classesShouldImplement(regex, clazz.getName(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldImplement(String regex, Class<?> clazz, TaikaiRule.Configuration configuration) {
        return this.classesShouldImplement(regex, clazz.getName(), configuration);
    }

    public JavaConfigurer classesShouldImplement(String regex, String typeName) {
        return this.classesShouldImplement(regex, typeName, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldImplement(String regex, String typeName, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleNameEndingWith(regex)).should().implement(typeName).as("Classes have name matching %s should implement %s".formatted(regex, typeName)), configuration));
    }

    public JavaConfigurer classesShouldHaveModifiers(String regex, Collection<JavaModifier> requiredModifiers) {
        return this.classesShouldHaveModifiers(regex, requiredModifiers, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer classesShouldHaveModifiers(String regex, Collection<JavaModifier> requiredModifiers, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should(ArchConditions.hasClassModifiers(requiredModifiers)).as("Classes have name matching %s should have all of this modifiers %s".formatted(regex, requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))), configuration));
    }

    public JavaConfigurer fieldsShouldNotBePublic() {
        return this.fieldsShouldNotBePublic(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer fieldsShouldNotBePublic(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.fields().should(ArchConditions.notBePublicUnlessStatic()).as("Fields should not be public unless they are static"), configuration));
    }

    public JavaConfigurer fieldsShouldHaveModifiers(String regex, Collection<JavaModifier> requiredModifiers) {
        return this.fieldsShouldHaveModifiers(regex, requiredModifiers, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer fieldsShouldHaveModifiers(String regex, Collection<JavaModifier> requiredModifiers, TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().haveNameMatching(regex)).should(ArchConditions.hasFieldModifiers(requiredModifiers)).as("Fields have name matching %s should have all of this modifiers %s".formatted(regex, requiredModifiers.stream().map(Enum::name).collect(Collectors.joining(", ")))), configuration));
    }

    public JavaConfigurer noUsageOf(Class<?> clazz) {
        return this.noUsageOf(clazz.getName(), null, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer noUsageOf(Class<?> clazz, String packageIdentifier) {
        return this.noUsageOf(clazz.getName(), packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer noUsageOf(Class<?> clazz, String packageIdentifier, TaikaiRule.Configuration configuration) {
        return this.noUsageOf(clazz.getName(), packageIdentifier, configuration);
    }

    public JavaConfigurer noUsageOf(Class<?> clazz, TaikaiRule.Configuration configuration) {
        return this.noUsageOf(clazz.getName(), null, configuration);
    }

    public JavaConfigurer noUsageOf(String typeName) {
        return this.noUsageOf(typeName, null, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer noUsageOf(String typeName, String packageIdentifier) {
        return this.noUsageOf(typeName, packageIdentifier, TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer noUsageOf(String typeName, TaikaiRule.Configuration configuration) {
        return this.noUsageOf(typeName, null, configuration);
    }

    public JavaConfigurer noUsageOf(String typeName, String packageIdentifier, TaikaiRule.Configuration configuration) {
        if (packageIdentifier != null) {
            return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((ClassesShouldConjunction)((GivenClassesConjunction)ArchRuleDefinition.noClasses().that().resideInAPackage(packageIdentifier)).should().dependOnClassesThat().areAssignableTo(typeName)).as("Classes %s reside in %s should not be used".formatted(typeName, packageIdentifier)), configuration));
        }
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)((ClassesShouldConjunction)ArchRuleDefinition.noClasses().should().dependOnClassesThat().areAssignableTo(typeName)).as("Classes %s should not be used".formatted(typeName)), configuration));
    }

    public JavaConfigurer noUsageOfSystemOutOrErr() {
        return this.noUsageOfSystemOutOrErr(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer noUsageOfSystemOutOrErr(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().should(NoSystemOutOrErr.notUseSystemOutOrErr()).as("Classes should not use System.out or System.err"), configuration));
    }

    public JavaConfigurer finalClassesShouldNotHaveProtectedMembers() {
        return this.finalClassesShouldNotHaveProtectedMembers(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer finalClassesShouldNotHaveProtectedMembers(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(DescribedPredicates.areFinal()).should(ProtectedMembers.notHaveProtectedMembers()).as("Final classes should not have protected members"), configuration));
    }

    public JavaConfigurer serialVersionUIDFieldsShouldBeStaticFinalLong() {
        return this.serialVersionUIDFieldsShouldBeStaticFinalLong(TaikaiRule.Configuration.defaultConfiguration());
    }

    public JavaConfigurer serialVersionUIDFieldsShouldBeStaticFinalLong(TaikaiRule.Configuration configuration) {
        return (JavaConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.fields().that(SerialVersionUID.namedSerialVersionUID()).should(SerialVersionUID.beStaticFinalLong()).as("serialVersionUID should be static final long"), configuration));
    }

    public static final class Disableable
    extends JavaConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public JavaConfigurer disable() {
            this.disable(JavaConfigurer.class);
            this.disable(ImportsConfigurer.class);
            this.disable(NamingConfigurer.class);
            return this;
        }
    }
}

