/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.java.ConstantNaming;
import com.enofex.taikai.java.PackageNaming;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.FieldsShouldConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenFieldsConjunction;
import com.tngtech.archunit.lang.syntax.elements.GivenMethodsConjunction;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;
import java.lang.annotation.Annotation;

public class NamingConfigurer
extends AbstractConfigurer {
    private static final String PACKAGE_NAME_REGEX = "^[a-z_]+(\\.[a-z_][a-z0-9_]*)*$";

    NamingConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public NamingConfigurer packagesShouldMatchDefault() {
        return this.packagesShouldMatch(PACKAGE_NAME_REGEX, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer packagesShouldMatchDefault(TaikaiRule.Configuration configuration) {
        return this.packagesShouldMatch(PACKAGE_NAME_REGEX, configuration);
    }

    public NamingConfigurer packagesShouldMatch(String regex) {
        return this.packagesShouldMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer packagesShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().should(PackageNaming.resideInPackageWithProperNamingConvention(regex)).as("Packages should have names matching %s".formatted(regex)), configuration));
    }

    public NamingConfigurer classesShouldNotMatch(String regex) {
        return this.classesShouldNotMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesShouldNotMatch(String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.noClasses().should().haveNameMatching(regex).as("Classes should not have names matching %s".formatted(regex)), configuration));
    }

    public NamingConfigurer classesAnnotatedWithShouldMatch(Class<? extends Annotation> annotationType, String regex) {
        return this.classesAnnotatedWithShouldMatch(annotationType.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesAnnotatedWithShouldMatch(Class<? extends Annotation> annotationType, String regex, TaikaiRule.Configuration configuration) {
        return this.classesAnnotatedWithShouldMatch(annotationType.getName(), regex, configuration);
    }

    public NamingConfigurer classesAnnotatedWithShouldMatch(String annotationType, String regex) {
        return this.classesAnnotatedWithShouldMatch(annotationType, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesAnnotatedWithShouldMatch(String annotationType, String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areMetaAnnotatedWith(annotationType)).should().haveNameMatching(regex).as("Classes annotated with %s should have names matching %s".formatted(annotationType, regex)), configuration));
    }

    public NamingConfigurer classesImplementingShouldMatch(Class<?> clazz, String regex) {
        return this.classesImplementingShouldMatch(clazz.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesImplementingShouldMatch(Class<?> clazz, String regex, TaikaiRule.Configuration configuration) {
        return this.classesImplementingShouldMatch(clazz.getName(), regex, configuration);
    }

    public NamingConfigurer classesImplementingShouldMatch(String typeName, String regex) {
        return this.classesImplementingShouldMatch(typeName, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesImplementingShouldMatch(String typeName, String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().implement(typeName)).should().haveNameMatching(regex).as("Classes implementing %s should have names matching %s".formatted(typeName, regex)), configuration));
    }

    public NamingConfigurer classesAssignableToShouldMatch(Class<?> clazz, String regex) {
        return this.classesAssignableToShouldMatch(clazz.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesAssignableToShouldMatch(Class<?> clazz, String regex, TaikaiRule.Configuration configuration) {
        return this.classesAssignableToShouldMatch(clazz.getName(), regex, configuration);
    }

    public NamingConfigurer classesAssignableToShouldMatch(String typeName, String regex) {
        return this.classesAssignableToShouldMatch(typeName, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer classesAssignableToShouldMatch(String typeName, String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areAssignableTo(typeName)).should().haveNameMatching(regex).as("Classes assignable to %s should have names matching %s".formatted(typeName, regex)), configuration));
    }

    public NamingConfigurer methodsAnnotatedWithShouldMatch(Class<? extends Annotation> annotationType, String regex) {
        return this.methodsAnnotatedWithShouldMatch(annotationType.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer methodsAnnotatedWithShouldMatch(Class<? extends Annotation> annotationType, String regex, TaikaiRule.Configuration configuration) {
        return this.methodsAnnotatedWithShouldMatch(annotationType.getName(), regex, configuration);
    }

    public NamingConfigurer methodsAnnotatedWithShouldMatch(String annotationType, String regex) {
        return this.methodsAnnotatedWithShouldMatch(annotationType, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer methodsAnnotatedWithShouldMatch(String annotationType, String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)((GivenMethodsConjunction)ArchRuleDefinition.methods().that().areMetaAnnotatedWith(annotationType)).should().haveNameMatching(regex)).as("Methods annotated with %s should have names matching %s".formatted(annotationType, regex)), configuration));
    }

    public NamingConfigurer methodsShouldNotMatch(String regex) {
        return this.methodsShouldNotMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer methodsShouldNotMatch(String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)ArchRuleDefinition.noMethods().should().haveNameMatching(regex)).as("Methods should not have names matching %s".formatted(regex)), configuration));
    }

    public NamingConfigurer fieldsAnnotatedWithShouldMatch(Class<? extends Annotation> annotationType, String regex) {
        return this.fieldsAnnotatedWithShouldMatch(annotationType.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer fieldsAnnotatedWithShouldMatch(Class<? extends Annotation> annotationType, String regex, TaikaiRule.Configuration configuration) {
        return this.fieldsAnnotatedWithShouldMatch(annotationType.getName(), regex, configuration);
    }

    public NamingConfigurer fieldsAnnotatedWithShouldMatch(String annotationType, String regex) {
        return this.fieldsAnnotatedWithShouldMatch(annotationType, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer fieldsAnnotatedWithShouldMatch(String annotationType, String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areMetaAnnotatedWith(annotationType)).should().haveNameMatching(regex)).as("Fields annotated with %s should have names matching %s".formatted(annotationType, regex)), configuration));
    }

    public NamingConfigurer fieldsShouldMatch(String typeName, String regex) {
        return this.fieldsShouldMatch(typeName, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer fieldsShouldMatch(Class<?> clazz, String regex) {
        return this.fieldsShouldMatch(clazz.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer fieldsShouldMatch(Class<?> clazz, String regex, TaikaiRule.Configuration configuration) {
        return this.fieldsShouldMatch(clazz.getName(), regex, configuration);
    }

    public NamingConfigurer fieldsShouldMatch(String typeName, String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((FieldsShouldConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().haveRawType(typeName)).should().haveNameMatching(regex)).as("Fields of type %s should have names matching %s".formatted(typeName, regex)), configuration));
    }

    public NamingConfigurer fieldsShouldNotMatch(String regex) {
        return this.fieldsShouldNotMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer fieldsShouldNotMatch(String regex, TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((FieldsShouldConjunction)ArchRuleDefinition.noFields().should().haveNameMatching(regex)).as("Fields should not have names matching %s".formatted(regex)), configuration));
    }

    public NamingConfigurer interfacesShouldNotHavePrefixI() {
        return this.interfacesShouldNotHavePrefixI(TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer interfacesShouldNotHavePrefixI(TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areInterfaces()).should(NamingConfigurer.notBePrefixedWithI()).as("Interfaces should not be prefixed with I"), configuration));
    }

    private static ArchCondition<JavaClass> notBePrefixedWithI() {
        return new ArchCondition<JavaClass>("not be prefixed with I", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (javaClass.getSimpleName().startsWith("I") && Character.isUpperCase(javaClass.getSimpleName().charAt(1))) {
                    events.add(SimpleConditionEvent.violated((Object)javaClass, (String)javaClass.getSimpleName()));
                }
            }
        };
    }

    public NamingConfigurer constantsShouldFollowConventions() {
        return this.constantsShouldFollowConventions(TaikaiRule.Configuration.defaultConfiguration());
    }

    public NamingConfigurer constantsShouldFollowConventions(TaikaiRule.Configuration configuration) {
        return (NamingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenFieldsConjunction)((GivenFieldsConjunction)ArchRuleDefinition.fields().that().areFinal()).and().areStatic()).should(ConstantNaming.shouldFollowConstantNamingConventions()).as("Constants should follow constant naming conventions"), configuration));
    }

    public static final class Disableable
    extends NamingConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public NamingConfigurer disable() {
            this.disable(NamingConfigurer.class);
            return this;
        }
    }
}

