/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;

final class NoSystemOutOrErr {
    private NoSystemOutOrErr() {
    }

    static ArchCondition<JavaClass> notUseSystemOutOrErr() {
        return new ArchCondition<JavaClass>("not call System.out or System.err", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                javaClass.getFieldAccessesFromSelf().stream().filter(fieldAccess -> fieldAccess.getTargetOwner().isEquivalentTo(System.class)).forEach(fieldAccess -> {
                    String fieldName = ((AccessTarget.FieldAccessTarget)fieldAccess.getTarget()).getName();
                    if ("out".equals(fieldName) || "err".equals(fieldName)) {
                        events.add(SimpleConditionEvent.violated((Object)fieldAccess, (String)"Method %s calls %s.%s".formatted(fieldAccess.getOrigin().getFullName(), fieldAccess.getTargetOwner().getName(), ((AccessTarget.FieldAccessTarget)fieldAccess.getTarget()).getName())));
                    }
                });
            }
        };
    }
}

