/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.regex.Pattern;

final class PackageNaming {
    private PackageNaming() {
    }

    static ArchCondition<JavaClass> resideInPackageWithProperNamingConvention(final String regex) {
        return new ArchCondition<JavaClass>("reside in package with proper naming convention", new Object[0]){
            private final Pattern pattern;
            {
                super(description, args);
                this.pattern = Pattern.compile(regex);
            }

            public void check(JavaClass javaClass, ConditionEvents events) {
                String packageName = javaClass.getPackageName();
                if (!this.pattern.matcher(packageName).matches()) {
                    events.add(SimpleConditionEvent.violated((Object)javaClass, (String)"Package '%s' does not follow the naming convention".formatted(packageName)));
                }
            }
        };
    }
}

