/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.internal.Modifiers;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;

final class ProtectedMembers {
    private ProtectedMembers() {
    }

    static ArchCondition<JavaClass> notHaveProtectedMembers() {
        return new ArchCondition<JavaClass>("not have protected members", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                for (JavaField field : javaClass.getFields()) {
                    if (!Modifiers.isFieldProtected(field)) continue;
                    events.add(SimpleConditionEvent.violated((Object)field, (String)"Field %s in final class %s is protected".formatted(field.getName(), javaClass.getName())));
                }
                for (JavaMethod method : javaClass.getMethods()) {
                    if (!Modifiers.isMethodProtected(method)) continue;
                    events.add(SimpleConditionEvent.violated((Object)method, (String)"Method %s in final class %s is protected".formatted(method.getName(), javaClass.getName())));
                }
            }
        };
    }
}

