/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.internal.Modifiers;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;

final class SerialVersionUID {
    private SerialVersionUID() {
    }

    static ArchCondition<JavaField> beStaticFinalLong() {
        return new ArchCondition<JavaField>("be static final long", new Object[0]){

            public void check(JavaField javaField, ConditionEvents events) {
                if (!(Modifiers.isFieldStatic(javaField) && Modifiers.isFieldFinal(javaField) && 1.isLong(javaField))) {
                    events.add(SimpleConditionEvent.violated((Object)javaField, (String)"Field %s in class %s is not static final long".formatted(javaField.getName(), javaField.getOwner().getName())));
                }
            }

            private static boolean isLong(JavaField javaField) {
                return javaField.getRawType().isEquivalentTo(Long.TYPE);
            }
        };
    }

    static DescribedPredicate<JavaField> namedSerialVersionUID() {
        return new DescribedPredicate<JavaField>("named serialVersionUID", new Object[0]){

            public boolean test(JavaField javaField) {
                return "serialVersionUID".equals(javaField.getName());
            }
        };
    }
}

