/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.java;

import com.enofex.taikai.internal.Modifiers;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;

final class UtilityClasses {
    private UtilityClasses() {
    }

    static GivenClassesConjunction utilityClasses() {
        return ArchRuleDefinition.classes().that(UtilityClasses.haveOnlyStaticMethods());
    }

    private static DescribedPredicate<JavaClass> haveOnlyStaticMethods() {
        return new DescribedPredicate<JavaClass>("have only static methods", new Object[0]){

            public boolean test(JavaClass javaClass) {
                return !javaClass.getMethods().isEmpty() && javaClass.getMethods().stream().allMatch(method -> Modifiers.isMethodStatic(method) && !"main".equals(method.getName()));
            }
        };
    }

    static ArchCondition<JavaClass> havePrivateConstructor() {
        return new ArchCondition<JavaClass>("have a private constructor", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (2.hasNoPrivateConstructor(javaClass)) {
                    events.add(SimpleConditionEvent.violated((Object)javaClass, (String)"Class %s does not have a private constructor".formatted(javaClass.getName())));
                }
            }

            private static boolean hasNoPrivateConstructor(JavaClass javaClass) {
                return javaClass.getConstructors().stream().noneMatch(Modifiers::isConstructorPrivate);
            }
        };
    }
}

