/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.logging;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.internal.ArchConditions;
import com.enofex.taikai.logging.LoggerConventions;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.util.Collection;
import java.util.List;

public class LoggingConfigurer
extends AbstractConfigurer {
    public LoggingConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public LoggingConfigurer classesShouldUseLogger(String typeName, String regex) {
        return this.classesShouldUseLogger(typeName, regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public LoggingConfigurer classesShouldUseLogger(Class<?> clazz, String regex) {
        return this.classesShouldUseLogger(clazz.getName(), regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public LoggingConfigurer classesShouldUseLogger(Class<?> clazz, String regex, TaikaiRule.Configuration configuration) {
        return this.classesShouldUseLogger(clazz.getName(), regex, configuration);
    }

    public LoggingConfigurer classesShouldUseLogger(String typeName, String regex, TaikaiRule.Configuration configuration) {
        return (LoggingConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should(ArchConditions.haveFieldOfType(typeName)).as("Classes with names matching %s should use a logger of type %s".formatted(regex, typeName)), configuration));
    }

    public LoggingConfigurer loggersShouldFollowConventions(String typeName, String regex) {
        return this.loggersShouldFollowConventions(typeName, regex, List.of(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public LoggingConfigurer loggersShouldFollowConventions(String typeName, String regex, TaikaiRule.Configuration configuration) {
        return this.loggersShouldFollowConventions(typeName, regex, List.of(), configuration);
    }

    public LoggingConfigurer loggersShouldFollowConventions(Class<?> clazz, String regex) {
        return this.loggersShouldFollowConventions(clazz.getName(), regex, List.of(), TaikaiRule.Configuration.defaultConfiguration());
    }

    public LoggingConfigurer loggersShouldFollowConventions(Class<?> clazz, String regex, TaikaiRule.Configuration configuration) {
        return this.loggersShouldFollowConventions(clazz.getName(), regex, List.of(), configuration);
    }

    public LoggingConfigurer loggersShouldFollowConventions(String typeName, String regex, Collection<JavaModifier> requiredModifiers) {
        return this.loggersShouldFollowConventions(typeName, regex, requiredModifiers, TaikaiRule.Configuration.defaultConfiguration());
    }

    public LoggingConfigurer loggersShouldFollowConventions(Class<?> clazz, String regex, Collection<JavaModifier> requiredModifiers) {
        return this.loggersShouldFollowConventions(clazz.getName(), regex, requiredModifiers, TaikaiRule.Configuration.defaultConfiguration());
    }

    public LoggingConfigurer loggersShouldFollowConventions(Class<?> clazz, String regex, Collection<JavaModifier> requiredModifiers, TaikaiRule.Configuration configuration) {
        return this.loggersShouldFollowConventions(clazz.getName(), regex, requiredModifiers, configuration);
    }

    public LoggingConfigurer loggersShouldFollowConventions(String typeName, String regex, Collection<JavaModifier> requiredModifiers, TaikaiRule.Configuration configuration) {
        return (LoggingConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().should(LoggerConventions.followLoggerConventions(typeName, regex, requiredModifiers)).as("Loggers in classes matching %s should follow conventions and be of type %s with required modifiers %s".formatted(regex, typeName, requiredModifiers)), configuration));
    }

    public static final class Disableable
    extends LoggingConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public LoggingConfigurer disable() {
            this.disable(LoggingConfigurer.class);
            return this;
        }
    }
}

