/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.spring;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.spring.SpringDescribedPredicates;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;

public class ConfigurationsConfigurer
extends AbstractConfigurer {
    private static final String DEFAULT_CONFIGURATION_NAME_MATCHING = ".+Configuration";

    ConfigurationsConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public ConfigurationsConfigurer namesShouldEndWithConfiguration() {
        return this.namesShouldMatch(DEFAULT_CONFIGURATION_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ConfigurationsConfigurer namesShouldEndWithConfiguration(TaikaiRule.Configuration configuration) {
        return this.namesShouldMatch(DEFAULT_CONFIGURATION_NAME_MATCHING, configuration);
    }

    public ConfigurationsConfigurer namesShouldMatch(String regex) {
        return this.namesShouldMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ConfigurationsConfigurer namesShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (ConfigurationsConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are((DescribedPredicate)SpringDescribedPredicates.annotatedWithConfiguration(true).and(DescribedPredicate.not(SpringDescribedPredicates.annotatedWithSpringBootApplication(true))))).should().haveNameMatching(regex).as("Configurations should have name ending %s".formatted(regex)), configuration));
    }

    public static final class Disableable
    extends ConfigurationsConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public ConfigurationsConfigurer disable() {
            this.disable(ConfigurationsConfigurer.class);
            return this;
        }
    }
}

