/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.spring;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.spring.SpringDescribedPredicates;
import com.enofex.taikai.spring.ValidatedController;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;

public class ControllersConfigurer
extends AbstractConfigurer {
    private static final String DEFAULT_CONTROLLER_NAME_MATCHING = ".+Controller";

    ControllersConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public ControllersConfigurer namesShouldEndWithController() {
        return this.namesShouldMatch(DEFAULT_CONTROLLER_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer namesShouldEndWithController(TaikaiRule.Configuration configuration) {
        return this.namesShouldMatch(DEFAULT_CONTROLLER_NAME_MATCHING, configuration);
    }

    public ControllersConfigurer namesShouldMatch(String regex) {
        return this.namesShouldMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer namesShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithControllerOrRestController(true))).should().haveNameMatching(regex).as("Controllers should have name ending %s".formatted(regex)), configuration));
    }

    public ControllersConfigurer shouldBeAnnotatedWithRestController() {
        return this.shouldBeAnnotatedWithRestController(DEFAULT_CONTROLLER_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBeAnnotatedWithRestController(TaikaiRule.Configuration configuration) {
        return this.shouldBeAnnotatedWithRestController(DEFAULT_CONTROLLER_NAME_MATCHING, configuration);
    }

    public ControllersConfigurer shouldBeAnnotatedWithRestController(String regex) {
        return this.shouldBeAnnotatedWithRestController(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBeAnnotatedWithRestController(String regex, TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should((ArchCondition)ArchConditions.be(SpringDescribedPredicates.annotatedWithRestController(true))).as("Controllers should be annotated with %s".formatted("org.springframework.web.bind.annotation.RestController")), configuration));
    }

    public ControllersConfigurer shouldBeAnnotatedWithController() {
        return this.shouldBeAnnotatedWithController(DEFAULT_CONTROLLER_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBeAnnotatedWithController(TaikaiRule.Configuration configuration) {
        return this.shouldBeAnnotatedWithController(DEFAULT_CONTROLLER_NAME_MATCHING, configuration);
    }

    public ControllersConfigurer shouldBeAnnotatedWithController(String regex) {
        return this.shouldBeAnnotatedWithController(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBeAnnotatedWithController(String regex, TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should((ArchCondition)ArchConditions.be(SpringDescribedPredicates.annotatedWithController(true))).as("Controllers should be annotated with %s".formatted("org.springframework.web.bind.annotation.Controller")), configuration));
    }

    public ControllersConfigurer shouldBePackagePrivate() {
        return this.shouldBePackagePrivate(TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBePackagePrivate(TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithControllerOrRestController(true))).should().bePackagePrivate().as("Controllers should be package-private"), configuration));
    }

    public ControllersConfigurer shouldNotDependOnOtherControllers() {
        return this.shouldNotDependOnOtherControllers(TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldNotDependOnOtherControllers(TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithControllerOrRestController(true))).should(ArchConditions.not((ArchCondition)ArchConditions.dependOnClassesThat((DescribedPredicate)ArchPredicates.are(SpringDescribedPredicates.annotatedWithControllerOrRestController(true))))).as("Controllers should not be depend on other Controllers"), configuration));
    }

    public ControllersConfigurer shouldBeAnnotatedWithValidated(String regex) {
        return this.shouldBeAnnotatedWithValidated(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBeAnnotatedWithValidated(String regex, TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should(ValidatedController.beAnnotatedWithValidated()).as("Validation annotations on @RequestParam or @PathVariable require the controller to be annotated with %s.".formatted("org.springframework.validation.annotation.Validated")), configuration));
    }

    public ControllersConfigurer shouldBeAnnotatedWithValidated() {
        return this.shouldBeAnnotatedWithValidated(TaikaiRule.Configuration.defaultConfiguration());
    }

    public ControllersConfigurer shouldBeAnnotatedWithValidated(TaikaiRule.Configuration configuration) {
        return (ControllersConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithControllerOrRestController(true))).should(ValidatedController.beAnnotatedWithValidated()).as("Validation annotations on @RequestParam or @PathVariable require the controller to be annotated with %s.".formatted("org.springframework.validation.annotation.Validated")), configuration));
    }

    public static final class Disableable
    extends ControllersConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public ControllersConfigurer disable() {
            this.disable(ControllersConfigurer.class);
            return this;
        }
    }
}

