/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.spring;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.spring.SpringDescribedPredicates;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;

public class PropertiesConfigurer
extends AbstractConfigurer {
    private static final String DEFAULT_PROPERTIES_NAME_MATCHING = ".+Properties";

    PropertiesConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public PropertiesConfigurer namesShouldEndWithProperties() {
        return this.namesShouldMatch(DEFAULT_PROPERTIES_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public PropertiesConfigurer namesShouldEndWithProperties(TaikaiRule.Configuration configuration) {
        return this.namesShouldMatch(DEFAULT_PROPERTIES_NAME_MATCHING, configuration);
    }

    public PropertiesConfigurer namesShouldMatch(String regex) {
        return this.namesShouldMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public PropertiesConfigurer namesShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (PropertiesConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithConfigurationProperties(true))).should().haveNameMatching(regex).as("Properties should have name ending %s".formatted(regex)), configuration));
    }

    public PropertiesConfigurer shouldBeAnnotatedWithValidated() {
        return this.shouldBeAnnotatedWithValidated(TaikaiRule.Configuration.defaultConfiguration());
    }

    public PropertiesConfigurer shouldBeAnnotatedWithValidated(TaikaiRule.Configuration configuration) {
        return (PropertiesConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithConfigurationProperties(true))).should().beMetaAnnotatedWith("org.springframework.validation.annotation.Validated").as("Configuration properties annotated with %s should be annotated with %s as well".formatted("org.springframework.boot.context.properties.ConfigurationProperties", "org.springframework.validation.annotation.Validated")), configuration));
    }

    public PropertiesConfigurer shouldBeAnnotatedWithConfigurationProperties() {
        return this.shouldBeAnnotatedWithConfigurationProperties(DEFAULT_PROPERTIES_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public PropertiesConfigurer shouldBeAnnotatedWithConfigurationProperties(TaikaiRule.Configuration configuration) {
        return this.shouldBeAnnotatedWithConfigurationProperties(DEFAULT_PROPERTIES_NAME_MATCHING, configuration);
    }

    public PropertiesConfigurer shouldBeAnnotatedWithConfigurationProperties(String regex) {
        return this.shouldBeAnnotatedWithConfigurationProperties(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public PropertiesConfigurer shouldBeAnnotatedWithConfigurationProperties(String regex, TaikaiRule.Configuration configuration) {
        return (PropertiesConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should((ArchCondition)ArchConditions.be(SpringDescribedPredicates.annotatedWithConfigurationProperties(true))).as("Configuration properties should be annotated with %s".formatted("org.springframework.boot.context.properties.ConfigurationProperties")), configuration));
    }

    public static final class Disableable
    extends PropertiesConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public PropertiesConfigurer disable() {
            this.disable(PropertiesConfigurer.class);
            return this;
        }
    }
}

