/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.spring;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.spring.SpringDescribedPredicates;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;

public class RepositoriesConfigurer
extends AbstractConfigurer {
    private static final String DEFAULT_REPOSITORY_NAME_MATCHING = ".+Repository";

    RepositoriesConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public RepositoriesConfigurer namesShouldEndWithRepository() {
        return this.namesShouldMatch(DEFAULT_REPOSITORY_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public RepositoriesConfigurer namesShouldEndWithRepository(TaikaiRule.Configuration configuration) {
        return this.namesShouldMatch(DEFAULT_REPOSITORY_NAME_MATCHING, configuration);
    }

    public RepositoriesConfigurer namesShouldMatch(String regex) {
        return this.namesShouldMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public RepositoriesConfigurer namesShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (RepositoriesConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithRepository(true))).should().haveNameMatching(regex).as("Repositories should have name ending %s".formatted(regex)), configuration));
    }

    public RepositoriesConfigurer shouldBeAnnotatedWithRepository() {
        return this.shouldBeAnnotatedWithRepository(DEFAULT_REPOSITORY_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public RepositoriesConfigurer shouldBeAnnotatedWithRepository(TaikaiRule.Configuration configuration) {
        return this.shouldBeAnnotatedWithRepository(DEFAULT_REPOSITORY_NAME_MATCHING, configuration);
    }

    public RepositoriesConfigurer shouldBeAnnotatedWithRepository(String regex) {
        return this.shouldBeAnnotatedWithRepository(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public RepositoriesConfigurer shouldBeAnnotatedWithRepository(String regex, TaikaiRule.Configuration configuration) {
        return (RepositoriesConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should((ArchCondition)ArchConditions.be(SpringDescribedPredicates.annotatedWithRepository(true))).as("Repositories should be annotated with %s".formatted("org.springframework.stereotype.Repository")), configuration));
    }

    public RepositoriesConfigurer shouldNotDependOnServices() {
        return this.shouldNotDependOnServices(TaikaiRule.Configuration.defaultConfiguration());
    }

    public RepositoriesConfigurer shouldNotDependOnServices(TaikaiRule.Configuration configuration) {
        return (RepositoriesConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithRepository(true))).should(ArchConditions.not((ArchCondition)ArchConditions.dependOnClassesThat(SpringDescribedPredicates.annotatedWithService(true)))).as("Repositories should not depend on Services"), configuration));
    }

    public static final class Disableable
    extends RepositoriesConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public RepositoriesConfigurer disable() {
            this.disable(RepositoriesConfigurer.class);
            return this;
        }
    }
}

