/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.spring;

import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.spring.SpringDescribedPredicates;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;

public class ServicesConfigurer
extends AbstractConfigurer {
    private static final String DEFAULT_SERVICE_NAME_MATCHING = ".+Service";

    ServicesConfigurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public ServicesConfigurer namesShouldEndWithService() {
        return this.namesShouldMatch(DEFAULT_SERVICE_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ServicesConfigurer namesShouldEndWithService(TaikaiRule.Configuration configuration) {
        return this.namesShouldMatch(DEFAULT_SERVICE_NAME_MATCHING, configuration);
    }

    public ServicesConfigurer namesShouldMatch(String regex) {
        return this.namesShouldMatch(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ServicesConfigurer namesShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (ServicesConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithService(true))).should().haveNameMatching(regex).as("Services should have name ending %s".formatted(regex)), configuration));
    }

    public ServicesConfigurer shouldBeAnnotatedWithService() {
        return this.shouldBeAnnotatedWithService(DEFAULT_SERVICE_NAME_MATCHING, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ServicesConfigurer shouldBeAnnotatedWithService(TaikaiRule.Configuration configuration) {
        return this.shouldBeAnnotatedWithService(DEFAULT_SERVICE_NAME_MATCHING, configuration);
    }

    public ServicesConfigurer shouldBeAnnotatedWithService(String regex) {
        return this.shouldBeAnnotatedWithService(regex, TaikaiRule.Configuration.defaultConfiguration());
    }

    public ServicesConfigurer shouldBeAnnotatedWithService(String regex, TaikaiRule.Configuration configuration) {
        return (ServicesConfigurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveNameMatching(regex)).should((ArchCondition)ArchConditions.be(SpringDescribedPredicates.annotatedWithService(true))).as("Services should be annotated with %s".formatted("org.springframework.stereotype.Service")), configuration));
    }

    public ServicesConfigurer shouldNotDependOnControllers() {
        return this.shouldNotDependOnControllers(TaikaiRule.Configuration.defaultConfiguration());
    }

    public ServicesConfigurer shouldNotDependOnControllers(TaikaiRule.Configuration configuration) {
        return (ServicesConfigurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.classes().that(ArchPredicates.are(SpringDescribedPredicates.annotatedWithService(true))).should(ArchConditions.not((ArchCondition)ArchConditions.dependOnClassesThat(SpringDescribedPredicates.annotatedWithControllerOrRestController(true)))).as("Services should not depend on Controllers or RestControllers"), configuration));
    }

    public static final class Disableable
    extends ServicesConfigurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public ServicesConfigurer disable() {
            this.disable(ServicesConfigurer.class);
            return this;
        }
    }
}

