/*
 * Decompiled with CFR 0.152.
 */
package com.enofex.taikai.test;

import com.enofex.taikai.Namespace;
import com.enofex.taikai.TaikaiRule;
import com.enofex.taikai.configures.AbstractConfigurer;
import com.enofex.taikai.configures.ConfigurerContext;
import com.enofex.taikai.configures.DisableableConfigurer;
import com.enofex.taikai.internal.ArchConditions;
import com.enofex.taikai.test.ContainAssertionsOrVerifications;
import com.enofex.taikai.test.JUnit5DescribedPredicates;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import com.tngtech.archunit.lang.syntax.elements.MethodsShouldConjunction;

public class JUnit5Configurer
extends AbstractConfigurer {
    private static final TaikaiRule.Configuration CONFIGURATION = TaikaiRule.Configuration.of(Namespace.IMPORT.ONLY_TESTS);

    JUnit5Configurer(ConfigurerContext configurerContext) {
        super(configurerContext);
    }

    public JUnit5Configurer methodsShouldMatch(String regex) {
        return this.methodsShouldMatch(regex, CONFIGURATION);
    }

    public JUnit5Configurer methodsShouldMatch(String regex, TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)ArchRuleDefinition.methods().that(ArchPredicates.are(JUnit5DescribedPredicates.annotatedWithTestOrParameterizedTest(true))).should().haveNameMatching(regex)).as("Methods annotated with %s or %s should have names matching %s".formatted("org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest", regex)), configuration));
    }

    public JUnit5Configurer methodsShouldNotDeclareExceptions() {
        return this.methodsShouldNotDeclareExceptions(CONFIGURATION);
    }

    public JUnit5Configurer methodsShouldNotDeclareExceptions(TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.methods().that(ArchPredicates.are(JUnit5DescribedPredicates.annotatedWithTestOrParameterizedTest(true))).should(ArchConditions.notDeclareThrownExceptions()).as("Methods annotated with %s or %s should not declare thrown Exceptions".formatted("org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest")), configuration));
    }

    public JUnit5Configurer methodsShouldBeAnnotatedWithDisplayName() {
        return this.methodsShouldBeAnnotatedWithDisplayName(CONFIGURATION);
    }

    public JUnit5Configurer methodsShouldBeAnnotatedWithDisplayName(TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)ArchRuleDefinition.methods().that(ArchPredicates.are(JUnit5DescribedPredicates.annotatedWithTestOrParameterizedTest(true))).should().beMetaAnnotatedWith("org.junit.jupiter.api.DisplayName")).as("Methods annotated with %s or %s should be annotated with %s".formatted("org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest", "org.junit.jupiter.api.DisplayName")), configuration));
    }

    public JUnit5Configurer methodsShouldBePackagePrivate() {
        return this.methodsShouldBePackagePrivate(CONFIGURATION);
    }

    public JUnit5Configurer methodsShouldBePackagePrivate(TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)ArchRuleDefinition.methods().that(ArchPredicates.are(JUnit5DescribedPredicates.annotatedWithTestOrParameterizedTest(true))).should().bePackagePrivate()).as("Methods annotated with %s or %s should be package-private".formatted("org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest")), configuration));
    }

    public JUnit5Configurer methodsShouldNotBeAnnotatedWithDisabled() {
        return this.methodsShouldNotBeAnnotatedWithDisabled(CONFIGURATION);
    }

    public JUnit5Configurer methodsShouldNotBeAnnotatedWithDisabled(TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)((MethodsShouldConjunction)ArchRuleDefinition.noMethods().should().beMetaAnnotatedWith("org.junit.jupiter.api.Disabled")).as("Methods should not be annotated with %s".formatted("org.junit.jupiter.api.Disabled")), configuration));
    }

    public JUnit5Configurer methodsShouldContainAssertionsOrVerifications() {
        return this.methodsShouldContainAssertionsOrVerifications(CONFIGURATION);
    }

    public JUnit5Configurer methodsShouldContainAssertionsOrVerifications(TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.methods().that(ArchPredicates.are(JUnit5DescribedPredicates.annotatedWithTestOrParameterizedTest(true))).should(ContainAssertionsOrVerifications.containAssertionsOrVerifications()).as("Methods annotated with %s or %s should contain assertions or verifications".formatted("org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest")), configuration));
    }

    public JUnit5Configurer classesShouldNotBeAnnotatedWithDisabled() {
        return this.classesShouldNotBeAnnotatedWithDisabled(CONFIGURATION);
    }

    public JUnit5Configurer classesShouldBePackagePrivate(String regex) {
        return this.classesShouldBePackagePrivate(regex, CONFIGURATION);
    }

    public JUnit5Configurer classesShouldBePackagePrivate(String regex, TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areNotInterfaces()).and().haveNameMatching(regex)).should().bePackagePrivate().as("Classes with names matching %s should be package-private".formatted(regex)), configuration));
    }

    public JUnit5Configurer classesShouldNotBeAnnotatedWithDisabled(TaikaiRule.Configuration configuration) {
        return (JUnit5Configurer)this.addRule(TaikaiRule.of((ArchRule)ArchRuleDefinition.noClasses().should().beMetaAnnotatedWith("org.junit.jupiter.api.Disabled").as("Classes should not be annotated with %s".formatted("org.junit.jupiter.api.Disabled")), configuration));
    }

    public static final class Disableable
    extends JUnit5Configurer
    implements DisableableConfigurer {
        public Disableable(ConfigurerContext configurerContext) {
            super(configurerContext);
        }

        public JUnit5Configurer disable() {
            this.disable(JUnit5Configurer.class);
            return this;
        }
    }
}

