/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.stream.Collectors;

final class FormatHelper {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    private FormatHelper() {
    }

    public static String bytesToHex(byte[] bytes) {
        return FormatHelper.bytesToHex(bytes, 0, bytes.length);
    }

    public static String bytesToHex(byte[] bytes, int len) {
        int from = 0;
        if (len < 0) {
            from = bytes.length + len;
            len = -len;
        }
        return FormatHelper.bytesToHex(bytes, from, len);
    }

    private static String bytesToHex(byte[] bytes, int from, int len) {
        char[] hexChars = new char[len * 2];
        int l = from + len;
        for (int j = from; j < l; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[(j - from) * 2] = hexArray[v >>> 4];
            hexChars[(j - from) * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String asPEM(String value, String label) {
        String header = FormatHelper.header(label);
        String footer = FormatHelper.footer(label);
        ArrayList<String> lines = new ArrayList<String>(Splitter.fixedLength((int)64).splitToList((CharSequence)value));
        lines.add(0, header);
        lines.add(footer);
        return lines.stream().collect(Collectors.joining("\r\n"));
    }

    public static boolean isPEMHeader(String line, String label) {
        return FormatHelper.header(label).equalsIgnoreCase(line);
    }

    public static boolean isPEMFooter(String line, String label) {
        return FormatHelper.footer(label).equalsIgnoreCase(line);
    }

    private static String header(String label) {
        return "-----BEGIN " + label + "-----";
    }

    private static String footer(String label) {
        return "-----END " + label + "-----";
    }
}

