/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.enonic.lib.license.FormatHelper;
import com.enonic.lib.license.PrivateKey;
import com.enonic.lib.license.PublicKey;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class KeyPair {
    private static final String KEY_PAIR_HEADER = "LICENSE-KEY-PAIR";
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public KeyPair(java.security.KeyPair rsaKeyPair) {
        this.privateKey = new PrivateKey(rsaKeyPair.getPrivate());
        this.publicKey = new PublicKey(rsaKeyPair.getPublic());
    }

    private KeyPair(PublicKey publicKey, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyPair keyPair = (KeyPair)o;
        return Objects.equals(this.privateKey, keyPair.privateKey) && Objects.equals(this.publicKey, keyPair.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.publicKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("private", (Object)this.privateKey).add("public", (Object)this.publicKey).toString();
    }

    public String serialize() {
        String priv = this.privateKey.serialize();
        String pub = this.publicKey.serialize();
        String pair = priv + "." + pub;
        return FormatHelper.asPEM(pair, KEY_PAIR_HEADER);
    }

    public static KeyPair from(String value) {
        if (value == null) {
            return null;
        }
        String[] allLines = value.split("\\r?\\n");
        List lines = Arrays.stream(allLines).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (lines.size() < 3) {
            return null;
        }
        String header = (String)lines.get(0);
        String footer = (String)lines.get(lines.size() - 1);
        lines.remove(0);
        lines.remove(lines.size() - 1);
        if (!FormatHelper.isPEMHeader(header, KEY_PAIR_HEADER) || !FormatHelper.isPEMFooter(footer, KEY_PAIR_HEADER)) {
            return null;
        }
        String keyPairStr = lines.stream().collect(Collectors.joining(""));
        int p = keyPairStr.indexOf(46);
        if (p == -1) {
            return null;
        }
        String priv = keyPairStr.substring(0, p).trim();
        String pub = keyPairStr.substring(p + 1).trim();
        PrivateKey privateKey = PrivateKey.from(priv);
        PublicKey publicKey = PublicKey.from(pub);
        if (privateKey == null || publicKey == null) {
            return null;
        }
        return new KeyPair(publicKey, privateKey);
    }
}

