/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class LicenseDetails {
    private final String issuedTo;
    private final String issuedBy;
    private final Instant issueTime;
    private final Instant expiryTime;
    private final ImmutableMap<String, String> data;

    private LicenseDetails(Builder builder) {
        this.issuedTo = builder.issuedTo == null ? "" : builder.issuedTo;
        this.issuedBy = builder.issuedBy == null ? "" : builder.issuedBy;
        this.issueTime = builder.issueTime;
        this.expiryTime = builder.expiryTime;
        this.data = ImmutableMap.copyOf(builder.data);
    }

    public String getIssuedTo() {
        return this.issuedTo;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public Instant getIssueTime() {
        return this.issueTime;
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    public ImmutableMap<String, String> getProperties() {
        return this.data;
    }

    public String getProperty(String key) {
        return (String)this.data.get((Object)key);
    }

    public String getProperty(String key, String defaultValue) {
        return (String)this.data.getOrDefault((Object)key, (Object)defaultValue);
    }

    public boolean isExpired() {
        return this.expiryTime != null && Instant.now().isAfter(this.expiryTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LicenseDetails that = (LicenseDetails)o;
        return Objects.equals(this.issuedTo, that.issuedTo) && Objects.equals(this.issuedBy, that.issuedBy) && Objects.equals(this.issueTime, that.issueTime) && Objects.equals(this.expiryTime, that.expiryTime) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.issuedTo, this.issuedBy, this.issueTime, this.expiryTime, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issuedTo", (Object)this.issuedTo).add("issuedBy", (Object)this.issuedBy).add("issueTime", (Object)this.issueTime).add("expiryTime", (Object)this.expiryTime).add("data", this.data).toString();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(LicenseDetails license) {
        return new Builder(license);
    }

    public static class Builder {
        private String issuedTo;
        private String issuedBy;
        private Instant issueTime;
        private Instant expiryTime;
        private Map<String, String> data;

        private Builder() {
            this.data = new HashMap<String, String>();
        }

        private Builder(LicenseDetails license) {
            this.issuedTo = license.issuedTo;
            this.issuedBy = license.issuedBy;
            this.issueTime = license.issueTime;
            this.expiryTime = license.expiryTime;
            this.data = new HashMap<String, String>();
            this.data.putAll((Map<String, String>)license.data);
        }

        public Builder issuedTo(String issuedTo) {
            this.issuedTo = issuedTo;
            return this;
        }

        public Builder issuedBy(String issuedBy) {
            this.issuedBy = issuedBy;
            return this;
        }

        public Builder issueTime(Instant issueTime) {
            this.issueTime = issueTime;
            return this;
        }

        public Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder property(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            if (properties != null) {
                this.data.putAll(properties);
            }
            return this;
        }

        public LicenseDetails build() {
            return new LicenseDetails(this);
        }
    }
}

