/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.enonic.lib.license.LicenseDetails;
import com.enonic.lib.license.LicenseDetailsJson;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

final class LicenseDetailsJSONConverter {
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    LicenseDetailsJSONConverter() {
    }

    public static String serialize(LicenseDetails licenseDetails) {
        try {
            return MAPPER.writeValueAsString((Object)new LicenseDetailsJson(licenseDetails));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot serialize license", e);
        }
    }

    public static LicenseDetails parse(String licenseDetails) {
        try {
            LicenseDetailsJson licenseDetailsJson = (LicenseDetailsJson)MAPPER.readValue(licenseDetails, LicenseDetailsJson.class);
            return licenseDetailsJson.toLicense();
        }
        catch (IOException e) {
            return null;
        }
    }
}

