/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.enonic.lib.license.LicenseDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;

final class LicenseDetailsJson {
    @JsonProperty(value="issuedTo")
    private String issuedTo;
    @JsonProperty(value="issuedBy")
    private String issuedBy;
    @JsonProperty(value="issueTime")
    private String issueTime;
    @JsonProperty(value="expiryTime")
    private String expiryTime;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    public LicenseDetailsJson() {
    }

    public LicenseDetailsJson(LicenseDetails licenseDetails) {
        this.issuedTo = licenseDetails.getIssuedTo();
        this.issuedBy = licenseDetails.getIssuedBy();
        this.issueTime = this.instantToString(licenseDetails.getIssueTime());
        this.expiryTime = this.instantToString(licenseDetails.getExpiryTime());
        this.properties = licenseDetails.getProperties();
    }

    public LicenseDetails toLicense() {
        return LicenseDetails.create().issuedTo(this.issuedTo).issuedBy(this.issuedBy).expiryTime(this.stringToInstant(this.expiryTime)).issueTime(this.stringToInstant(this.issueTime)).properties(this.properties).build();
    }

    private String instantToString(Instant instant) {
        return instant == null ? null : instant.toString();
    }

    private Instant stringToInstant(String instant) {
        if (instant == null) {
            return null;
        }
        DateTimeFormatter f = DateTimeFormatter.ISO_INSTANT;
        try {
            return Instant.from(f.parse(instant));
        }
        catch (Exception e) {
            return null;
        }
    }
}

