/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.enonic.lib.license.FormatHelper;
import com.google.common.base.MoreObjects;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;

public final class PrivateKey {
    private final java.security.PrivateKey privateKey;

    PrivateKey(java.security.PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    java.security.PrivateKey getRsaKey() {
        return this.privateKey;
    }

    public String serialize() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.privateKey.getEncoded());
    }

    public static PrivateKey from(String value) {
        if (value == null) {
            return null;
        }
        try {
            byte[] keyBytes = Base64.getUrlDecoder().decode(value.trim());
            java.security.PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
            return new PrivateKey(privateKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivateKey that = (PrivateKey)o;
        return Objects.equals(this.privateKey, that.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey);
    }

    public String toString() {
        String pre = FormatHelper.bytesToHex(this.privateKey.getEncoded(), 3);
        String str = pre + "..." + FormatHelper.bytesToHex(this.privateKey.getEncoded(), -3);
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)str).toString();
    }
}

