/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license;

import com.enonic.lib.license.FormatHelper;
import com.google.common.base.MoreObjects;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;

public final class PublicKey {
    private final java.security.PublicKey publicKey;

    PublicKey(java.security.PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public java.security.PublicKey getRsaKey() {
        return this.publicKey;
    }

    public String serialize() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.publicKey.getEncoded());
    }

    public static PublicKey from(String value) {
        if (value == null) {
            return null;
        }
        try {
            byte[] keyBytes = Base64.getUrlDecoder().decode(value.trim());
            java.security.PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
            return new PublicKey(publicKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey publicKey1 = (PublicKey)o;
        return Objects.equals(this.publicKey, publicKey1.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.publicKey);
    }

    public String toString() {
        String pre = FormatHelper.bytesToHex(this.publicKey.getEncoded(), 3);
        String str = pre + "..." + FormatHelper.bytesToHex(this.publicKey.getEncoded(), -3);
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)str).toString();
    }
}

